<?php
$post_blocks_hide = Helper::get_post_blocks_hide();

$thumb_size = THEME_SLUG . '_single_thumbnail_full';
if ( Helper::is_single_about_full_height() ) {
	$thumb_size = 'full';
}
?>
<div class="section-post section-post_promo post">
    <div class="section-post__image section-post__image_main image-overlay image-overlay_gradient">
		<?php if ( get_post_thumbnail_id() ) { ?>
			<?php the_post_thumbnail( $thumb_size ); ?>
		<?php } ?>
    </div>
    <div class="container">
        <div class="post__body">
			<?php
			if ( ! in_array( 'category', $post_blocks_hide ) ) {
				if ( is_singular( 'catalog_item' ) ) {
					card_custom_category( 'catalogcat_wescle' );
				}
				else {
					post_card_category();
				}
			}
			?>

			<?php if ( ! get_post_meta( $post->ID, 'hide_page_title', 1 ) ) { ?>
                <div class="post__title">
                    <h1 class="title" itemprop="headline"><?php the_title(); ?></h1>
                </div>
			<?php } ?>

			<?php if ( $post->post_excerpt && ! in_array( 'excerpt', $post_blocks_hide ) ) { ?>
                <div class="post__text"><?php the_excerpt(); ?></div>
			<?php } ?>
        </div>
    </div>
    <script>
        if (document.body.classList.contains('post-fullscreen')) {
            const headerHeight = document.querySelector('.header').getBoundingClientRect().height;
            document.querySelector('.section-post').style.height = `calc(100vh - ${headerHeight}px)`;
        }
    </script>
</div>