<?php
$next_post = get_next_post( true );
$prev_post = get_previous_post( true );

if ( $next_post || $prev_post ) {
	?>
    <div class="section-post__navigation posts-navigation">
		<?php if ( $prev_post ) { ?>
            <a class="posts-navigation__button posts-navigation__prev-post" href="<?php echo esc_url( get_permalink( $prev_post->ID ) ); ?>">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(90deg); -webkit-transform: rotate(90deg); transform: rotate(90deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 32 32">
                    <g fill="none" stroke="#626262" stroke-linecap="round" stroke-linejoin="round" stroke-width="4">
                        <path d="M30 12L16 24L2 12"></path>
                    </g>
                </svg>
                <div class="posts-navigation__description">
                    <div class="posts-navigation__name"><?php esc_html_e( 'Предыдущая запись', 'wescle' ); ?></div>
                    <div class="posts-navigation__title"><?php echo wp_kses_post( get_the_title( $prev_post->ID ) ); ?></div>
                </div>
            </a>
		<?php } ?>
		<?php if ( $next_post ) { ?>
			<?php
			if ( ! $prev_post ) {
				echo '<span></span>';
			}
			?>
            <a class="posts-navigation__button posts-navigation__next-post" href="<?php echo esc_url( get_permalink( $next_post->ID ) ); ?>">
                <div class="posts-navigation__description">
                    <div class="posts-navigation__name"><?php esc_html_e( 'Следующая запись', 'wescle' ); ?></div>
                    <div class="posts-navigation__title"><?php echo wp_kses_post( get_the_title( $next_post->ID ) ); ?></div>
                </div>
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(-90deg); -webkit-transform: rotate(-90deg); transform: rotate(-90deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 32 32">
                    <g fill="none" stroke="#626262" stroke-linecap="round" stroke-linejoin="round" stroke-width="4">
                        <path d="M30 12L16 24L2 12"></path>
                    </g>
                </svg>
            </a>
		<?php } ?>
    </div>
	<?php
}
