<?php
$enabled = get_theme_mod( 'catalog_navigation_enabled' );
if ( ! $enabled ) {
	return;
}
$items = get_theme_mod( 'catalog_navigation_items', [] );
if ( ! $items ) {
	return;
}
$button_text  = get_post_meta( $post->ID, 'button_text', 1 );
$button_url   = get_post_meta( $post->ID, 'button_link', 1 );
$target_blank = get_post_meta( $post->ID, 'button_link_is_blank', 1 ) ? 'target="_blank" rel="noopener noreferrer"' : '';

$btn_flare = '';
if ( get_theme_mod( 'catalog_button_type' ) == 'animation' ) {
	$btn_flare = ' btn-flare';
}
?>
<div class="_sticky-nav _hide">
    <div class="container">
        <div class="_sticky-nav__menu">
            <div class="_sticky-nav__body">
				<?php foreach ( $items as $item ) { ?>
					<?php $target = Helper::is_external_url( $item['id'] ) ? ' target="_blank" rel="noopener noreferrer"' : ''; ?>
                    <a href="<?php echo $item['id']; ?>"<?php echo $target; ?>><?php echo $item['text']; ?></a>
				<?php } ?>
            </div>
            <div class="_sticky-nav__yet _hide">
                <button class="_sticky-nav__yet-toggle" type="button" aria-label="Show more"><span></span><span></span><span></span></button>
                <div class="_sticky-nav__yet-dropdown">
                    <div class="_sticky-nav__yet-body"></div>
                </div>
            </div>
        </div>
		<?php if ( $button_text && $button_url ) { ?>
            <div class="_sticky-nav__actions _hide">
                <a class="btn btn-main btn-main_blue btn-order_catalog short<?php echo $btn_flare; ?>" href="<?php echo $button_url; ?>" <?php echo $target_blank; ?> data-name="<?php echo esc_attr( $post->post_title ); ?>" data-url="<?php echo esc_url( get_permalink( $post ) ); ?>"><span><?php echo $button_text; ?></span></a>
            </div>
		<?php } ?>
    </div>
</div>