<?php
$images       = Helper::get_catalog_images( $post );
$count_images = count( $images );
if ( ! $count_images ) {
	return;
}

$meta_items = get_post_meta( $post->ID, 'wescle_catalog_images', 1 );
if ( ! $meta_items ) {
	$meta_items = [];
}
$meta_items = array_merge(
	[
		[
			'img_id'       => get_post_thumbnail_id(),
			'file_id'      => get_post_meta( $post->ID, 'youtube_link', 1 ),
			'youtube_link' => get_post_meta( $post->ID, 'video_file', 1 ),
		]
	],
	$meta_items
);
?>
<div class="_main-gallery _<?php echo $count_images; ?>" id="catelog-gallery-<?php echo $post->ID; ?>">
	<?php
	foreach ( $images as $key => $img_id ) {
		if ( ! $img_id ) {
			continue;
		}

		$link_class = '_main-gallery-item';
		$label_view = __( 'Просмотреть в полноэкранном режиме', 'wescle' );

		$youtube_link = $meta_items[ $key ]['youtube_link'];
		$video_file   = $meta_items[ $key ]['file_id'];

		$url  = wp_get_attachment_url( $img_id );
		$size = 'medium_large';
		if ( $key == 0 && $count_images > 4 ) {
			$size = 'large';
		}
		if ( $count_images < 3 ) {
			$size = 'large';
		}

		if ( $youtube_link || $video_file ) {
			$label_view = __( 'Проиграть видео', 'wescle' );
			$link_class .= ' _main-gallery-item_video';
			if ( $video_file ) {
				$url = wp_get_attachment_url( $video_file );
			}
			else {
				$url = $youtube_link;
			}
		}
		?>
        <a class="<?php echo $link_class; ?>" data-fslightbox="gallery-catalog" href="<?php echo $url; ?>">
			<?php echo wp_get_attachment_image( $img_id, $size ); ?>
            <div class="_main-gallery-item__view"><?php echo $label_view; ?></div>
        </a>
		<?php
		if ( $key == 4 ) {
			break;
		}
	}
	?>
	<?php if ( $count_images > 5 ) { ?>
        <div class="_main-gallery__other">
			<?php
			foreach ( $images as $key => $img_id ) {
				if ( $key < 5 ) {
					continue;
				}

				$youtube_link = $meta_items[ $key ]['youtube_link'];
				$video_file   = $meta_items[ $key ]['file_id'];
				if ( $youtube_link || $video_file ) {
					if ( $video_file ) {
						$url = wp_get_attachment_url( $video_file );
					}
					else {
						$url = $youtube_link;
					}
				}

				$url = wp_get_attachment_url( $img_id );
				?>
                <a class="_main-gallery-item" data-fslightbox="gallery-catalog" href="<?php echo $url; ?>"></a>
				<?php
			}
			?>
        </div>
	<?php } ?>
</div>