<?php
$author_id   = get_the_author_meta( 'ID' );
$description = get_the_author_meta( 'description' );
$social_text = esc_html__( 'Связь', 'wescle' );
?>
<div class="section-post__bottom">
    <div class="author-info">
        <div class="author-info__photo">
			<?php echo get_avatar( $author_id, 120 ); ?>
        </div>
        <div class="author-info__body">
            <div class="author-info__name">
                <span class="author-info__name-label"><?php esc_html_e( 'Опубликовал(а)', 'wescle' ); ?></span>
				<?php
				$wrapper = '<%1$s class="name" href="%2$s">%3$s</%1$s>';
				$tag     = 'a';
				if ( class_exists( 'WPSEO_Options' ) && WPSEO_Options::get( 'disable-author' ) ) {
					$tag = 'span';
				}
				echo sprintf( $wrapper, $tag, esc_url( get_author_posts_url( $author_id ) ), get_the_author() );
				?>
            </div>
			<?php if ( $description ) { ?>
                <div class="author-info__text"><?php echo nl2br( $description ); ?></div>
			<?php } ?>

			<?php
			set_query_var( 'template_args', [ 'user_id' => $author_id, 'text' => $social_text ] );
			get_template_part( 'template-parts/archive/author', 'social' );
			?>
        </div>
    </div>
</div>