<?php
if ( ! get_theme_mod( 'module_popup_enabled', false ) ) {
	return;
}

$modal_posts = get_posts( [
	'post_type'        => 'popup_wescle',
	'posts_per_page'   => - 1,
	'meta_query'       => [
		[
			'key'   => 'modal_on',
			'value' => '1',
		]
	],
	'suppress_filters' => false
] );

foreach ( $modal_posts as $modal_post ) {
	if ( ! Helper::is_active_popup_on_page( $modal_post ) ) {
		continue;
	}

	$atts = 'id="popup_wescle-modal-' . $modal_post->ID . '"';
	$atts .= ' data-id="' . $modal_post->ID . '"';
	if ( 'auto' == get_post_meta( $modal_post->ID, 'modal_work', 1 ) ) {
		$time = intval( get_post_meta( $modal_post->ID, 'auto_timer', 1 ) ) * 1000;
		$atts .= ' data-open-by-time="' . $time . '"';

		$time_cookie = get_post_meta( $modal_post->ID, 'time_cookie', 1 );
		if ( ! $time_cookie ) {
			//$time_cookie = 1;
		}
		$atts .= ' data-noopen-days="' . $time_cookie . '"';
	}

	$overlay       = get_post_meta( $modal_post->ID, 'overlay', 1 );
	$overlay_class = 'modal-box__overlay';
	if ( $overlay == 'white' ) {
		$overlay_class .= ' modal-box__overlay_blur-white';
	}
	elseif ( $overlay == 'dark' ) {
		$overlay_class .= ' modal-box__overlay_blur-black';
	}

	$text = trim( $modal_post->post_content ) ? wpautop( do_shortcode( $modal_post->post_content ) ) : '';
	$text = str_replace(
		[ '<h1>', '</h1>', '<h2>', '</h2>', '<h3>', '</h3>', '<h4>', '</h4>' ],
		[ '<div class="modal-subtitle h2">', '</div>', '<div class="modal-subtitle h2">', '</div>', '<div class="modal-subtitle h3">', '</div>', '<div class="modal-subtitle h4">', '</div>' ],
		$text
	);

	$modal_data = [
		'id'          => $modal_post->ID,
		'class'       => 'popup_wescle_wescle-modal-' . $modal_post->ID,
		'title'       => $modal_post->post_title,
		'text'        => $text,
		'text_bottom' => get_post_meta( $modal_post->ID, 'text_bottom', 1 ),
		'image_id'    => get_post_thumbnail_id( $modal_post ),
		'work'        => get_post_meta( $modal_post->ID, 'modal_work', 1 ),
		'type'        => get_post_meta( $modal_post->ID, 'type', 1 ),
		'overlay'     => $overlay_class,
		'cf7'         => get_post_meta( $modal_post->ID, 'cf7', 1 ),
		'atts'        => $atts,
	];

	get_template_part( 'template-parts/modals/modal', 'wescle_v' . $modal_data['type'], [ 'data' => $modal_data ] );
}