<?php
$button_sortable = get_theme_mod( 'fixed_button_sortable', Helper::get_default_theme_data( 'fixed_button_sortable' ) );
$langs_enable    = get_theme_mod( 'fixed_button_langs_enabled', true );
$tel_enable      = get_theme_mod( 'fixed_button_tel_enabled', true );
$email_enable    = get_theme_mod( 'fixed_button_email_enabled', true );
$darkmode_enable = get_theme_mod( 'module_dark_mode_enabled' );
$buttons_others  = get_theme_mod( 'fixed_button_others', [] );

$hide_link = get_theme_mod( 'fixed_button_hide_link' );

if ( $tel_enable || $email_enable || $buttons_others || $langs_enable || $darkmode_enable ) {
	echo '<div class="call-modals-buttons__wrap">';
	$phone = get_theme_mod( 'fixed_button_tel', '' );

	if ( ! $phone ) {
		$phone = get_theme_mod( 'phone_primary', __( '+38 (000) 000-00-00', 'wescle' ) );
	}

	$email = get_theme_mod( 'fixed_button_email', '' );
	if ( ! $email ) {
		$email = get_theme_mod( 'email_primary', '' );
	}
	if ( ! $email ) {
		$email = get_option( 'admin_email' );
	}

	foreach ( $button_sortable as $block ) {
		switch ( $block ) {
			case 'langs':
				get_template_part( 'template-parts/modals/langs' );
				break;
			case 'phone':
				if ( $tel_enable ) {
					?>
                    <a class="call-button" href="tel:<?php echo Helper::phone_number_format( $phone ); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                            <g fill="#626262">
                                <path d="M13 8a3 3 0 0 1 3 3a1 1 0 0 0 2 0a5 5 0 0 0-5-5a1 1 0 0 0 0 2z"></path>
                                <path d="M13 4a7 7 0 0 1 7 7a1 1 0 0 0 2 0a9 9 0 0 0-9-9a1 1 0 0 0 0 2zm8.75 11.91a1 1 0 0 0-.72-.65l-6-1.37a1 1 0 0 0-.92.26c-.14.13-.15.14-.8 1.38a9.91 9.91 0 0 1-4.87-4.89C9.71 10 9.72 10 9.85 9.85a1 1 0 0 0 .26-.92L8.74 3a1 1 0 0 0-.65-.72a3.79 3.79 0 0 0-.72-.18A3.94 3.94 0 0 0 6.6 2A4.6 4.6 0 0 0 2 6.6A15.42 15.42 0 0 0 17.4 22a4.6 4.6 0 0 0 4.6-4.6a4.77 4.77 0 0 0-.06-.76a4.34 4.34 0 0 0-.19-.73z"></path>
                            </g>
                        </svg>
                    </a>
					<?php
				}
				break;
			case 'email':
				if ( $email_enable ) {
					if ( $hide_link ) {
						echo '<span class="mail-button js-link" data-link="mailto:' . strip_tags( $email ) . '">';
					}
					else {
						echo '<a class="mail-button" href="mailto:' . strip_tags( $email ) . '">';
					}
					?>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                        <g fill="none">
                            <path d="M2.003 5.884L10 9.882l7.997-3.998A2 2 0 0 0 16 4H4a2 2 0 0 0-1.997 1.884z" fill="white"></path>
                            <path d="M18 8.118l-8 4l-8-4V14a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8.118z" fill="white"></path>
                        </g>
                    </svg>
					<?php
					if ( $hide_link ) {
						echo '</span>';
					}
					else {
						echo '</a>';
					}
				}
				break;
			case 'darkmode':
				if ( $darkmode_enable ) {
					$auto_toggle  = get_theme_mod( 'module_dark_mode_auto' ) ? 'true' : 'false';
					$color_scheme = get_theme_mod( 'module_dark_mode_scheme', 'light' );
					?>
                    <button class="color-scheme-toggle" type="button" data-auto-toggle="<?php echo $auto_toggle; ?>" data-color-scheme="<?php echo $color_scheme; ?>">
                        <svg class="moon" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img" width="1em" height="1em" preserveaspectratio="xMidYMid meet" viewbox="0 0 16 16">
                            <path fill="currentColor"
                                  d="M6 .278a.768.768 0 0 1 .08.858a7.208 7.208 0 0 0-.878 3.46c0 4.021 3.278 7.277 7.318 7.277c.527 0 1.04-.055 1.533-.16a.787.787 0 0 1 .81.316a.733.733 0 0 1-.031.893A8.349 8.349 0 0 1 8.344 16C3.734 16 0 12.286 0 7.71C0 4.266 2.114 1.312 5.124.06A.752.752 0 0 1 6 .278zM4.858 1.311A7.269 7.269 0 0 0 1.025 7.71c0 4.02 3.279 7.276 7.319 7.276a7.316 7.316 0 0 0 5.205-2.162c-.337.042-.68.063-1.029.063c-4.61 0-8.343-3.714-8.343-8.29c0-1.167.242-2.278.681-3.286z"></path>
                        </svg>
                        <svg class="sun" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img" width="1em" height="1em" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                            <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 1 1-8 0a4 4 0 0 1 8 0Z"></path>
                        </svg>
                    </button>
					<?php
				}
				break;
			case 'button_others':
				foreach ( $buttons_others as $button ) {
					if ( ! $button['image'] ) {
						continue;
					}

					$as_span = $hide_link ? true : false;
					$target  = $button['is_blank'] ? true : false;

					$markup = wescle_markup_external_link( 'call-button custom-button', $as_span, $target );

					echo str_replace( '%url%', strip_tags( $button['url'] ), $markup['tag_open'] );
					echo wp_get_attachment_image( $button['image'] );
					echo $markup['tag_close'];
				}
				break;
		}
	}

	echo '</div>';
}