<?php
if ( ! Helper::visible_block_in_customizer( 'woo_blocks' ) ) {
	return;
}

$blocks_before_promo = $args['before_promo'] ?? '';

$woo_blocks = get_theme_mod( 'woo_blocks_items', [] );
foreach ( $woo_blocks as $key => $block ) {
	if ( 1 != $block['woo_block_on'] ) {
		continue;
	}

	if ( isset( $block['woo_block_before_promo'] ) && $block['woo_block_before_promo'] ) {
		if ( $blocks_before_promo ) {

		}
		else {
			continue;
		}
	}
	else {
		if ( $blocks_before_promo ) {
			continue;
		}
	}

	$slider_enabled = $block['woo_block_slider_enabled'] ?? true;
	$grid_count     = $block['woo_block_category_grid_count'] ?? 5;
	$slides_count   = $block['woo_block_count_slides'] ?? 5;
	$slider_speed   = $block['woo_block_slider_speed'] ?? 5;
	$slider_speed   = intval( $slider_speed ) * 1000;

	$slider_dots = 'false';
	if ( isset( $block['woo_block_slider_dots'] ) && $block['woo_block_slider_dots'] ) {
		$slider_dots = 'true';
	}

	$slider_arrows = 'false';
	if ( isset( $block['woo_block_slider_arrow'] ) && $block['woo_block_slider_arrow'] ) {
		$slider_arrows = 'true';
	}
	elseif ( ! isset( $block['woo_block_slider_arrow'] ) ) {
		$slider_arrows = 'true';
	}

	$slider_arrows_mobile = '';
	if ( isset( $block['woo_block_slider_arrow_mobile'] ) && ! $block['woo_block_slider_arrow_mobile'] ) {
		$slider_arrows_mobile = '_hide-arrows-mobile';
	}

	$block['slider_enabled']       = $slider_enabled;
	$block['grid_count']           = $grid_count;
	$block['slides_count']         = $slides_count;
	$block['slider_speed']         = $slider_speed;
	$block['slider_dots']          = $slider_dots;
	$block['slider_arrows']        = $slider_arrows;
	$block['slider_arrows_mobile'] = $slider_arrows_mobile;

	if ( $block['woo_block_advt_before'] ) {
		set_query_var( 'template_args', [ 'code' => $block['woo_block_advt_before'], 'container' => true ] );
		get_template_part( 'template-parts/section/advt', '' );
	}

	if ( 'category' == $block['woo_block_type'] ) {
		get_template_part( 'template-parts/section/woo', 'category', [ 'block' => $block, 'key_block' => $key ] );
	}
	elseif ( 'product' == $block['woo_block_type'] ) {
		get_template_part( 'template-parts/section/woo', 'products', [ 'block' => $block, 'key_block' => $key ] );
	}

	if ( $block['woo_block_advt_after'] ) {
		set_query_var( 'template_args', [ 'code' => $block['woo_block_advt_after'], 'container' => true ] );
		get_template_part( 'template-parts/section/advt', '' );
	}
}