<?php
if ( ! Helper::is_woocommerce_active() ) {
	return;
}

$block_enabled = get_theme_mod( 'woo_banners_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$banner_items = get_theme_mod( 'woo_banners_items', [] );
if ( ! $banner_items ) {
	return;
}

$title      = get_theme_mod( 'woo_banners_title', Helper::get_default_theme_data( 'woo_banners_title' ) );
$title_type = get_theme_mod( 'woo_banners_title_type', 'div' );
$text       = get_theme_mod( 'woo_banners_text' );

$class_overlay = 'image-overlay_gradient';
if ( true == get_theme_mod( 'woo_banners_without_gradient', false ) ) {
	$class_overlay = '';
}

$style_bg = '';
if ( $color_bg = get_theme_mod( 'woo_banners_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'woo_banners_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'woo_banners_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="goods-banners<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'woo_banners_image_bg' ); ?>
    <div class="container">
		<?php if ( $title || $text ) { ?>
			<?php
			if ( $title ) {
				printf( '<%1$s class="title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
			<?php if ( $text ) { ?>
                <div class="_section-about">
                    <div class="_section-about__text"><?php echo $text; ?></div>
                </div>
			<?php } ?>
		<?php } ?>
        <div class="goods-banners__row">
			<?php foreach ( $banner_items as $item ) {
				$big_class = '';
				if ( isset( $item['banner_big'] ) && $item['banner_big'] ) {
					$big_class = ' goods-banners__col_big';
				}
				?>
                <div class="goods-banners__col<?php echo $big_class; ?>">
                    <div class="goods-banners-item">
                        <div class="goods-banners-item__image image-overlay <?php echo $class_overlay; ?>">
							<?php
							if ( $item['image'] ) {
								echo wp_get_attachment_image( $item['image'], 'medium_large' );
							}
							?>
                        </div>
                        <div class="goods-banners-item__body">
							<?php if ( $item['title'] ) { ?>
                                <div class="goods-banners-item__title title title_white"><?php echo $item['title']; ?></div>
							<?php } ?>
							<?php if ( $item['price'] ) { ?>
                                <div class="prices">
                                    <span class="price-current"><?php echo $item['price']; ?></span>
									<?php if ( $item['price_old'] ) { ?>
                                        <span class="price-old"><?php echo $item['price_old']; ?></span>
									<?php } ?>
                                </div>
							<?php } ?>
							<?php
							if ( $item['button_label'] && $item['button_url'] ) {
								$custom_class = '';

								if ( strpos( $item['button_url'], '#wescle-modal' ) !== false ) {
									$custom_class = '_popup-link';
								}

								if ( ! $custom_class ) {
									if ( $item['button_url'] == '#' || $item['button_url'] == '#modal-call' ) {
										$custom_class       = '_popup-link';
										$item['button_url'] = '#modal-call';
									}
								}

								$btn_flare = '';
								if ( get_theme_mod( 'woo_banner_button_type' ) == 'animation' ) {
									$btn_flare = 'btn-flare ';
								}
								?>
                                <a class="btn btn-main <?php echo $btn_flare; ?><?php echo $custom_class; ?>" href="<?php echo $item['button_url']; ?>"><?php echo $item['button_label']; ?></a>
							<?php } ?>
							<?php if ( isset( $item['link_label'] ) && $item['link_label'] && $item['link_url'] ) { ?>
                                <a class="goods-banners-item__link" href="<?php echo $item['link_url']; ?>" target="_blank" rel="noopener noreferrer"><?php echo $item['link_label']; ?></a>
							<?php } ?>
                        </div>
                    </div>
                </div>
			<?php } ?>
        </div>
    </div>
</div>