<?php
$block_enabled = get_theme_mod( 'home_why_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$title      = get_theme_mod( 'home_why_title' );
$title_type = get_theme_mod( 'home_why_title_type', 'div' );

$text        = get_theme_mod( 'home_why_text' );
$text_images = get_theme_mod( 'home_why_items_images', [] );

$title2      = get_theme_mod( 'home_why_title2' );
$block_items = get_theme_mod( 'home_why_items' );

$title_slider = get_theme_mod( 'home_why_title_slider' );
$slider_items = get_theme_mod( 'home_why_slider_images' );

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_why_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_why_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$slides_count         = get_theme_mod( 'home_why_settings_count', 8 );
$slider_speed         = get_theme_mod( 'home_why_settings_speed', 8 );
$slider_speed         = $slider_speed * 1000;
$slider_dots          = get_theme_mod( 'home_why_settings_dots', false ) == true ? 'true' : 'false';
$slider_arrows        = get_theme_mod( 'home_why_settings_arrow', true ) == true ? 'true' : 'false';
$slider_arrows_mobile = get_theme_mod( 'home_why_settings_arrow_mobile', true ) == true ? '' : '_hide-arrows-mobile';

$section_class    = '';
$section_position = get_theme_mod( 'home_why_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="why<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_what_site_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="why__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
		<?php if ( $text ) { ?>
            <div class="why-about _section-about">
                <div class="why-about__col">
                    <div class="why-about__text"><?php echo $text; ?></div>
                </div>
				<?php if ( $text_images ) { ?>
                <div class="why-about__col">
                    <div class="why-about__brands">
						<?php
						foreach ( $text_images as $item ) {
							if ( ! $item['image_id'] ) {
								continue;
							}
							?>
                            <div class="why-about__img">
								<?php echo wp_get_attachment_image( $item['image_id'], 'medium' ); ?>
                            </div>
						<?php } ?>
                    </div>
					<?php } ?>
                </div>
            </div>
		<?php } ?>
		<?php if ( $block_items ) { ?>
            <div class="why-functions">
				<?php if ( $title2 ) { ?>
                    <div class="why-functions__subtitle"><?php echo $title2; ?></div>
				<?php } ?>
                <div class="why-functions__row">
					<?php
					foreach ( $block_items as $item ) {
						if ( ! $item['image_id'] ) {
							continue;
						}
						?>
                        <div class="why-functions__col">
                            <div class="why-functions-item">
								<?php if ( $item['image_id'] ) { ?>
                                    <div class="why-functions-item__img">
										<?php echo wp_get_attachment_image( $item['image_id'] ); ?>
                                    </div>
								<?php } ?>
                                <div class="why-functions-item__text"><?php echo $item['title']; ?></div>
                            </div>
                        </div>
					<?php } ?>
                </div>
            </div>
		<?php } ?>
		<?php if ( $slider_items ) { ?>
            <div class="slider-wrapper <?php echo $slider_arrows_mobile; ?>">
                <div class="why__slider-header">
                    <div class="why__slider-title"><?php echo $title_slider; ?></div>
                    <div class="slider-buttons">
                        <button class="slider-buttons__item slider-buttons__item_prev" type="button">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(180deg); -webkit-transform: rotate(180deg); transform: rotate(180deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                                <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                            </svg>
                        </button>
                        <button class="slider-buttons__item slider-buttons__item_next" type="button">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                                <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                            </svg>
                        </button>
                    </div>
                </div>
                <div class="why__slider" data-slides="<?php echo $slides_count; ?>" data-autoplay-speed="<?php echo $slider_speed; ?>" data-dots="<?php echo $slider_dots; ?>" data-arrows="<?php echo $slider_arrows; ?>">
					<?php
					foreach ( $slider_items as $item ) {
						if ( ! $item['image_id'] ) {
							continue;
						}
						?>
                        <div class="why__slide">
                            <div class="why-item">
                                <div class="why-item__img">
									<?php echo wp_get_attachment_image( $item['image_id'], 'medium' ); ?>
                                </div>
                            </div>
                        </div>
					<?php } ?>
                </div>
            </div>
		<?php } ?>
    </div>
</div>