<?php
$block_enabled = get_theme_mod( 'home_what_site_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$title      = get_theme_mod( 'home_what_site_title' );
$title_type = get_theme_mod( 'home_what_site_title_type', 'div' );

$text  = get_theme_mod( 'home_what_site_text' );
$items = get_theme_mod( 'home_what_site_items', [] );

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_what_site_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_what_site_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$slides_count         = get_theme_mod( 'home_what_site_settings_count', 4 );
$slider_speed         = get_theme_mod( 'home_what_site_settings_speed', 8 );
$slider_speed         = $slider_speed * 1000;
$slider_dots          = get_theme_mod( 'home_what_site_settings_dots', false ) == true ? 'true' : 'false';
$slider_arrows        = get_theme_mod( 'home_what_site_settings_arrow', true ) == true ? 'true' : 'false';
$slider_arrows_mobile = get_theme_mod( 'home_what_site_settings_arrow_mobile', true ) == true ? '' : '_hide-arrows-mobile';

$section_class    = '';
$section_position = get_theme_mod( 'home_what_site_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="what-site<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_what_site_image_bg' ); ?>
    <div class="container">
        <div class="slider-wrapper <?php echo $slider_arrows_mobile; ?>">
            <div class="what-site__top _section-about">
                <div class="what-site__about">
					<?php
					if ( $title ) {
						printf( '<%1$s class="what-site__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
					}
					?>
					<?php if ( $text ) { ?>
                        <div class="what-site__text"><?php echo $text; ?></div>
					<?php } ?>
                </div>
                <div class="what-site__buttons slider-buttons">
                    <button class="slider-buttons__item slider-buttons__item_prev" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(180deg); -webkit-transform: rotate(180deg); transform: rotate(180deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                            <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                        </svg>
                    </button>
                    <button class="slider-buttons__item slider-buttons__item_next" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                            <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                        </svg>
                    </button>
                </div>
            </div>
			<?php if ( $items ) { ?>
                <div class="what-site__slider" data-slides="<?php echo $slides_count; ?>" data-autoplay-speed="<?php echo $slider_speed; ?>" data-dots="<?php echo $slider_dots; ?>" data-arrows="<?php echo $slider_arrows; ?>">
					<?php
					foreach ( $items as $item ) {
						$button       = [];
						$button_class = '';
						$link         = [];
						$link_class   = '';
						if ( $item['button_text'] && $item['button_url'] ) {
							$button = [
								'text' => $item['button_text'],
								'url'  => $item['button_url'],
							];
							if ( strpos( $item['button_url'], '#wescle-modal' ) !== false || $item['button_url'] == '#modal-call' ) {
								$button_class = '_popup-link';
							}
						}
						if ( $item['link_text'] && $item['link_url'] ) {
							$link = [
								'text' => $item['link_text'],
								'url'  => $item['link_url'],
							];
							if ( strpos( $item['link_url'], '#wescle-modal' ) !== false || $item['link_url'] == '#modal-call' ) {
								$link_class = '_popup-link';
							}
						}
						?>
                        <div class="what-site__slide">
                            <div class="what-site-item">
                                <div class="what-site-item__img">
									<?php
									if ( $item['image_id'] ) {
										echo wp_get_attachment_image( $item['image_id'], 'medium_large' );
									}
									?>
                                </div>
                                <div class="what-site-item__content">
                                    <div class="what-site-item__header">
                                        <strong><?php echo $item['title']; ?></strong>
                                        <span class="eye"> <svg class="close" xmlns="http://www.w3.org/2000/svg" width="27.847" height="22.118" viewbox="0 0 27.847 22.118"> <defs> <style>.eye-a, .eye-b {
                                                  fill: #fff;
                                                }

                                                .eye-b {
                                                  fill-rule: evenodd;
                                                }</style> </defs> <g transform="translate(0 -3.703)"> <path class="eye-a" d="M18.779,23.747l-2.81-2.811a6.092,6.092,0,0,1-7.787-7.787L4.6,9.563A23.588,23.588,0,0,0,0,15.2S5.221,24.77,13.924,24.77a12.234,12.234,0,0,0,4.856-1.023ZM9.068,6.648a12.232,12.232,0,0,1,4.856-1.023c8.7,0,13.924,9.573,13.924,9.573a23.7,23.7,0,0,1-4.6,5.635l-3.588-3.588a6.092,6.092,0,0,0-7.787-7.787L9.068,6.65Z" transform="translate(0 -0.435)"></path> <path class="eye-a"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 d="M12.418,16.109a4.351,4.351,0,0,0,4.924,4.924l-4.925-4.924Zm8.616,1.232L16.11,12.416a4.351,4.351,0,0,1,4.924,4.924Z"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 transform="translate(-2.802 -1.963)"></path> <path
                                                            class="eye-b" d="M24.59,25.821,3.7,4.935,4.936,3.7,25.822,24.589Z" transform="translate(-0.839)"></path> </g> </svg> <svg class="open" xmlns="http://www.w3.org/2000/svg" width="27.847" height="19" viewbox="0 0 27.847 19"> <defs> <style>.eye-a {
                                                  fill: #fff;
                                                }</style> </defs> <path class="eye-a"
                                                                        d="M13.954,2.441a14.4,14.4,0,0,1,8.461,2.642,14.876,14.876,0,0,1,5.432,6.858A14.888,14.888,0,0,1,22.414,18.8a14.4,14.4,0,0,1-8.461,2.642A14.534,14.534,0,0,1,5.463,18.8,14.819,14.819,0,0,1,0,11.941,14.825,14.825,0,0,1,5.463,5.083,14.532,14.532,0,0,1,13.954,2.441Zm0,15.853a6.017,6.017,0,0,0,4.453-1.871,6.166,6.166,0,0,0,1.84-4.483,6.166,6.166,0,0,0-1.84-4.483,6.017,6.017,0,0,0-4.453-1.871A6.113,6.113,0,0,0,9.471,7.458,6.119,6.119,0,0,0,7.6,11.941a6.111,6.111,0,0,0,1.871,4.483A6.117,6.117,0,0,0,13.954,18.294Zm-.03-10.153a3.735,3.735,0,0,1,2.7,1.1,3.623,3.623,0,0,1,1.128,2.7,3.623,3.623,0,0,1-1.128,2.7,3.735,3.735,0,0,1-2.7,1.1,3.637,3.637,0,0,1-2.672-1.1,3.674,3.674,0,0,1-1.1-2.7,3.751,3.751,0,0,1,3.77-3.8Z"
                                                                        transform="translate(0 -2.441)"></path> </svg>
                                        </span>
                                    </div>
                                    <div class="what-site-item__body">
                                        <div class="what-site-item__text"><?php echo nl2br( $item['text'] ); ?></div>
										<?php if ( $button ) { ?>
                                            <a class="what-site-item__btn btn btn-main <?php echo $button_class; ?>" href="<?php echo $button['url']; ?>"><span><?php echo $button['text']; ?></span></a>
										<?php } ?>
										<?php if ( $link ) { ?>
                                            <a class="what-site-item__link <?php echo $link_class; ?>" href="<?php echo $link['url']; ?>"><span><?php echo $button['text']; ?></span></a>
										<?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
						<?php
					}
					?>
                </div>
			<?php } ?>
        </div>
    </div>
</div>