<?php
$block_enabled = get_theme_mod( 'home_videos_max_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$title            = get_theme_mod( 'home_videos_max_title' );
$title_type       = get_theme_mod( 'home_videos_max_title_type', 'div' );
$text             = get_theme_mod( 'home_videos_max_text' );
$home_video_posts = get_theme_mod( 'home_videos_max_posts', [] );

$button_title = get_theme_mod( 'home_videos_max_button_title' );
$button_url   = get_theme_mod( 'home_videos_max_button_url' );
if ( ! $button_url ) {
	$button_link_id = get_theme_mod( 'home_videos_max_link_id' );
	if ( $button_link_id ) {
		$button_url = get_permalink( $button_link_id );
	}
}
$button_target_blank = get_theme_mod( 'home_videos_max_target_blank' ) ? 'target="_blank" rel="noopener noreferrer"' : '';

$video_post_ids = [];
foreach ( $home_video_posts as $item ) {
	if ( $item['post_id'] ) {
		$video_post_ids[] = $item['post_id'];
	}
}

$posts_per_page = 10;
$post__in       = [];
$orderby        = [ 'menu_order' => 'ASC', 'date' => 'DESC' ];

if ( $video_post_ids ) {
	$posts_per_page = count( $video_post_ids );
	$post__in       = $video_post_ids;
	$orderby        = 'post__in';
}

$args        = [
	'post_type'        => 'video_wescle',
	'posts_per_page'   => $posts_per_page,
	'post__in'         => $post__in,
	'orderby'          => $orderby,
	'suppress_filters' => false
];
$video_posts = get_posts( $args );
if ( ! $video_posts ) {
	return;
}

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_videos_max_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_videos_max_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_videos_max_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="video-max<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_videos_max_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="video-max__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
		<?php if ( $text ) { ?>
            <div class="_section-about">
                <div class="video-max__text"><?php echo $text; ?></div>
            </div>
		<?php } ?>
        <div class="video-max__grid">
            <div class="video-max-main">
                <div class="video-max-main__video">
					<?php
					$img = '';
					if ( $img_id = get_theme_mod( 'home_videos_max_image' ) ) {
						$img = wp_get_attachment_image_src( $img_id, 'large' );
					}
					foreach ( $video_posts as $post ) {
						setup_postdata( $post );
						$video_id = Helper::get_youtube_video_id( get_post_meta( $post->ID, 'youtube_link', 1 ) );
						if ( ! $video_id ) {
							continue;
						}
						if ( ! $img ) {
							$img = wp_get_attachment_image_src( get_post_thumbnail_id(), 'large' );
						}
						?>
                        <div class="_video-iframe" data-src="<?php echo $video_id; ?>" style="background-image: url('<?php echo $img[0]; ?>');">
                            <div class="btn-play">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 448 512">
                                    <path d="M424.4 214.7L72.4 6.6C43.8-10.3 0 6.1 0 47.9V464c0 37.5 40.7 60.1 72.4 41.3l352-208c31.4-18.5 31.5-64.1 0-82.6z" fill="white"></path>
                                </svg>
                            </div>
                        </div>
						<?php
						break;
					}
					?>
                </div>
            </div>
            <div class="video-max-list">
				<?php if ( $button_url && $button_title ) { ?>
                    <div class="video-max-block video-max-block_all">
                        <a class="video-max-block__btn btn btn-main" <?php echo $button_target_blank; ?> href="<?php echo $button_url; ?>"><?php echo $button_title; ?></a>
                    </div>
				<?php } ?>
				<?php
				foreach ( $video_posts as $post ) {
					setup_postdata( $post );
					$video_id = Helper::get_youtube_video_id( get_post_meta( $post->ID, 'youtube_link', 1 ) );
					if ( ! $video_id ) {
						continue;
					}
					?>
                    <a class="video-max-block" href="#" data-src="<?php echo $video_id; ?>">
                        <div class="video-max-block__img">
							<?php echo wp_get_attachment_image( get_post_thumbnail_id(), 'medium' ); ?>
                        </div>
                        <div class="video-max-block__body">
                            <div class="video-max-block__title"><?php the_title(); ?></div>
                            <div class="video-max-block__text">
								<?php
								if ( $post->post_excerpt ) {
									$text = $post->post_excerpt;
								}
								else {
									$text = wp_strip_all_tags( $post->post_content );
								}
								echo Helper::short_string( $text, 100 );
								?>
                            </div>
                        </div>
                    </a>
					<?php
				}
				wp_reset_postdata();
				?>
            </div>
        </div>
    </div>
</div>
