<?php
$block_enabled = get_theme_mod( 'home_videos2_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$title            = get_theme_mod( 'home_videos2_title' );
$title_type       = get_theme_mod( 'home_videos2_title_type', 'div' );
$text             = get_theme_mod( 'home_videos2_text' );
$home_video_posts = get_theme_mod( 'home_videos2_posts', [] );

$video_post_ids = [];
foreach ( $home_video_posts as $item ) {
	if ( $item['post_id'] ) {
		$video_post_ids[] = $item['post_id'];
	}
}

$posts_per_page = 10;
$post__in       = [];
$orderby        = [ 'menu_order' => 'ASC', 'date' => 'DESC' ];

if ( $video_post_ids ) {
	$posts_per_page = count( $video_post_ids );
	$post__in       = $video_post_ids;
	$orderby        = 'post__in';
}

$args        = [
	'post_type'        => 'video_wescle',
	'posts_per_page'   => $posts_per_page,
	'post__in'         => $post__in,
	'orderby'          => $orderby,
	'suppress_filters' => false
];
$video_posts = get_posts( $args );
if ( ! $video_posts ) {
	return;
}

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_videos2_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_videos2_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_videos2_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="video-section<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_videos2_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="video-section__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
		<?php if ( $text ) { ?>
            <div class="_section-about">
                <div class="video-section__text"><?php echo $text; ?></div>
            </div>
		<?php } ?>
        <div class="video-section__grid">
			<?php
			foreach ( $video_posts as $post ) {
				setup_postdata( $post );

				get_template_part( 'template-parts/content/video_cpt', 'item' );
			}
			wp_reset_postdata();
			?>
        </div>
    </div>
</div>
