<?php
$block_enabled = get_theme_mod( 'home_team_static_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$title             = get_theme_mod( 'home_team_static_title' );
$title_type        = get_theme_mod( 'home_team_static_title_type', 'div' );
$text              = get_theme_mod( 'home_team_static_text' );
$team_static_items = get_theme_mod( 'home_team_static_items', [] );
if ( ! $team_static_items ) {
	return;
}

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_team_static_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_team_static_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_team_static_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="the-team<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_team_static_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="the-team__title title title_divider title_center" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
		<?php if ( $text ) { ?>
            <div class="the-team__about">
                <div class="the-team__text"><?php echo $text; ?></div>
            </div>
		<?php } ?>
        <div class="the-team__grid">
			<?php foreach ( $team_static_items as $item ) { ?>
                <div class="the-team-item">
					<?php if ( $item['image'] ) { ?>
                        <div class="the-team-item__img">
							<?php echo wp_get_attachment_image( $item['image'], 'medium' ); ?>
                        </div>
					<?php } ?>
                    <div class="the-team-item__body">
                        <div class="the-team-item__name"><?php echo $item['title']; ?></div>
						<?php if ( $item['position'] ) { ?>
                            <div class="the-team-item__position"><?php echo $item['position']; ?></div>
						<?php } ?>
						<?php if ( $item['text'] ) { ?>
                            <div class="the-team-item__text"><?php echo $item['text']; ?></div>
						<?php } ?>
                    </div>
                </div>
			<?php } ?>
        </div>
    </div>
</div>