<?php
$block_enabled = get_theme_mod( 'home_team_cpt_enabled', false );
if ( ! $block_enabled ) {
	return;
}

if ( is_front_page() ) {
	if ( ! get_theme_mod( 'home_team_cpt_enabled_home', true ) ) {
		return;
	}
}

$title      = get_theme_mod( 'home_team_cpt_title' );
$title_type = get_theme_mod( 'home_team_cpt_title_type', 'div' );
$text       = get_theme_mod( 'home_team_cpt_text' );
$post_ids   = get_theme_mod( 'home_team_cpt_posts', [] );

$team_posts = get_posts( [
	'post_type'        => 'team_wescle',
	'posts_per_page'   => - 1,
	'post__in'         => $post_ids,
	'orderby'          => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
	'suppress_filters' => false
] );

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_team_cpt_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_team_cpt_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_team_cpt_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="about-team<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_team_cpt_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="about-team__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
        <div class="about-team__body">
			<?php if ( $text ) { ?>
                <div class="about-team__text"><?php echo $text; ?></div>
			<?php } ?>
            <div class="about-team-list">
				<?php
				foreach ( $team_posts as $post ) {
					setup_postdata( $post );

					get_template_part( 'template-parts/content/team', 'item' );
				}
				wp_reset_postdata();
				?>
            </div>
        </div>
    </div>
</div>