<?php
$block_enabled = get_theme_mod( 'home_team_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$title      = get_theme_mod( 'home_team_title' );
$title_type = get_theme_mod( 'home_team_title_type', 'div' );
$text       = get_theme_mod( 'home_team_text' );
$team_items = get_theme_mod( 'home_team_items', [] );
if ( ! $team_items ) {
	return;
}

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_team_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_team_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$slides_count         = get_theme_mod( 'home_team_settings_count', 4 );
$slider_speed         = get_theme_mod( 'home_team_settings_speed', 8 );
$slider_speed         = $slider_speed * 1000;
$slider_dots          = get_theme_mod( 'home_team_settings_dots', false ) == true ? 'true' : 'false';
$slider_arrows        = get_theme_mod( 'home_team_settings_arrow', true ) == true ? 'true' : 'false';
$slider_arrows_mobile = get_theme_mod( 'home_team_settings_arrow_mobile', true ) == true ? '' : '_hide-arrows-mobile';

$section_class    = '';
$section_position = get_theme_mod( 'home_team_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="team<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_team_image_bg' ); ?>
    <div class="container">
        <div class="slider-wrapper <?php echo $slider_arrows_mobile; ?>">
            <div class="team__top">
				<?php if ( $title || $text ) { ?>
                    <div class="team__about">
						<?php
						if ( $title ) {
							printf( '<%1$s class="team__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
						}
						?>
                        <div class="team__text">
							<?php echo $text; ?>
                        </div>
                    </div>
				<?php } ?>
                <div class="team__buttons slider-buttons">
                    <button class="slider-buttons__item slider-buttons__item_prev" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(180deg); -webkit-transform: rotate(180deg); transform: rotate(180deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                            <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                        </svg>
                    </button>
                    <button class="slider-buttons__item slider-buttons__item_next" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                            <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                        </svg>
                    </button>
                </div>
            </div>
            <div class="team__slider" data-slides="<?php echo $slides_count; ?>" data-autoplay-speed="<?php echo $slider_speed; ?>" data-dots="<?php echo $slider_dots; ?>" data-arrows="<?php echo $slider_arrows; ?>">
				<?php foreach ( $team_items as $key => $item ) { ?>
                    <div class="team__slide">
                        <div class="team-item">
                            <div class="team-item__image">
								<?php
								if ( $item['image'] ) {
									echo wp_get_attachment_image( $item['image'], 'medium_large' );
								}
								?>
                            </div>
                            <div class="team-item__body">
                                <div class="team-item__name"><?php echo $item['title']; ?></div>
								<?php if ( $item['position'] ) { ?>
                                    <div class="team-item__position"><?php echo $item['position']; ?></div>
								<?php } ?>
								<?php if ( $item['text'] ) { ?>
                                    <p class="team-item__text">
										<?php echo nl2br( $item['text'] ); ?>
										<?php if ( Helper::short_string( $item['text'] ) > 135 ) { ?>
                                            <button class="btn_expand btn_expand_white js-hide" type="button" data-text-open="" data-text-close="" data-height="125" data-team>
                                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                                    <g fill="none">
                                                        <path d="M4 9l8 8l8-8" stroke="#626262" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"></path>
                                                    </g>
                                                </svg>
                                                <span></span>
                                            </button>
										<?php } ?>
                                    </p>
								<?php } ?>
								<?php
								$contact_info = [];
								if ( $item['link_vk'] ) {
									$contact_info['vk'] = $item['link_vk'];
								}
								if ( $item['link_fb'] ) {
									$contact_info['fb'] = $item['link_fb'];
								}
								if ( $item['link_inst'] ) {
									$contact_info['inst'] = $item['link_inst'];
								}
								if ( $item['link_twitter'] ) {
									$contact_info['twitter'] = $item['link_twitter'];
								}
								if ( $item['email'] ) {
									$contact_info['email'] = $item['email'];
								}
								if ( $item['tel'] ) {
									$contact_info['tel'] = $item['tel'];
								}
								if ( $contact_info ) {
									$markup = wescle_markup_external_link( '', true );
									?>
                                    <ul class="team-item__contacts">
										<?php foreach ( $contact_info as $key_contact => $val ) { ?>
											<?php if ( $key_contact == 'vk' ) { ?>
                                                <li>
													<?php echo str_replace( '%url%', $val, $markup['tag_open'] ); ?>
                                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                                                        <path d="M10 .4C4.698.4.4 4.698.4 10s4.298 9.6 9.6 9.6s9.6-4.298 9.6-9.6S15.302.4 10 .4zm3.692 10.831s.849.838 1.058 1.227c.006.008.009.016.011.02c.085.143.105.254.063.337c-.07.138-.31.206-.392.212h-1.5c-.104 0-.322-.027-.586-.209c-.203-.142-.403-.375-.598-.602c-.291-.338-.543-.63-.797-.63a.305.305 0 0 0-.095.015c-.192.062-.438.336-.438 1.066c0 .228-.18.359-.307.359h-.687c-.234 0-1.453-.082-2.533-1.221c-1.322-1.395-2.512-4.193-2.522-4.219c-.075-.181.08-.278.249-.278h1.515c.202 0 .268.123.314.232c.054.127.252.632.577 1.2c.527.926.85 1.302 1.109 1.302a.3.3 0 0 0 .139-.036c.338-.188.275-1.393.26-1.643c0-.047-.001-.539-.174-.775c-.124-.171-.335-.236-.463-.26a.55.55 0 0 1 .199-.169c.232-.116.65-.133 1.065-.133h.231c.45.006.566.035.729.076c.33.079.337.292.308 1.021c-.009.207-.018.441-.018.717c0 .06-.003.124-.003.192c-.01.371-.022.792.24.965a.216.216 0 0 0 .114.033c.091 0 .365 0 1.107-1.273a9.718 9.718 0 0 0 .595-1.274c.015-.026.059-.106.111-.137a.266.266 0 0 1 .124-.029h1.781c.194 0 .327.029.352.104c.044.119-.008.482-.821 1.583l-.363.479c-.737.966-.737 1.015.046 1.748z"
                                                              fill="#626262"></path>
                                                    </svg>
													<?php echo $markup['tag_close']; ?>
                                                </li>
											<?php } ?>
											<?php if ( $key_contact == 'fb' ) { ?>
                                                <li>
													<?php echo str_replace( '%url%', $val, $markup['tag_open'] ); ?>
                                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                                                        <path d="M10 .4C4.698.4.4 4.698.4 10s4.298 9.6 9.6 9.6s9.6-4.298 9.6-9.6S15.302.4 10 .4zm2.274 6.634h-1.443c-.171 0-.361.225-.361.524V8.6h1.805l-.273 1.486H10.47v4.461H8.767v-4.461H7.222V8.6h1.545v-.874c0-1.254.87-2.273 2.064-2.273h1.443v1.581z" fill="#626262"></path>
                                                    </svg>
													<?php echo $markup['tag_close']; ?>
                                                </li>
											<?php } ?>
											<?php if ( $key_contact == 'inst' ) { ?>
                                                <li>
													<?php echo str_replace( '%url%', $val, $markup['tag_open'] ); ?>
                                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 1024 1024">
                                                        <path d="M512 1024q-104 0-199-40.5t-163.5-109T40.5 711T0 512t40.5-199t109-163.5T313 40.5T512 0t199 40.5t163.5 109t109 163.5t40.5 199t-40.5 199t-109 163.5t-163.5 109t-199 40.5zm256-704q0-26-18.5-45T704 256H320q-26 0-45 19t-19 45v64h114q58-64 142-64t142 64h114v-64zM384 512q0 53 37.5 90.5T512 640t90.5-37.5T640 512t-37.5-90.5T512 384t-90.5 37.5T384 512zm384-64h-76q12 33 12 64q0 80-56 136t-136 56t-136-56t-56-136q0-31 12-64h-76v256q0 27 18.5 45.5T320 768h384q27 0 45.5-18.5T768 704V448z"
                                                              fill="#626262"></path>
                                                    </svg>
													<?php echo $markup['tag_close']; ?>
                                                </li>
											<?php } ?>
											<?php if ( $key_contact == 'twitter' ) { ?>
                                                <li>
													<?php echo str_replace( '%url%', $val, $markup['tag_open'] ); ?>
                                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                                                        <path d="M10 .4C4.698.4.4 4.698.4 10s4.298 9.6 9.6 9.6s9.6-4.298 9.6-9.6S15.302.4 10 .4zm3.905 7.864c.004.082.005.164.005.244c0 2.5-1.901 5.381-5.379 5.381a5.335 5.335 0 0 1-2.898-.85c.147.018.298.025.451.025c.886 0 1.701-.301 2.348-.809a1.895 1.895 0 0 1-1.766-1.312a1.9 1.9 0 0 0 .853-.033a1.892 1.892 0 0 1-1.517-1.854v-.023c.255.141.547.227.857.237a1.89 1.89 0 0 1-.585-2.526a5.376 5.376 0 0 0 3.897 1.977a1.891 1.891 0 0 1 3.222-1.725a3.797 3.797 0 0 0 1.2-.459a1.9 1.9 0 0 1-.831 1.047a3.799 3.799 0 0 0 1.086-.299a3.834 3.834 0 0 1-.943.979z"
                                                              fill="#626262"></path>
                                                    </svg>
													<?php echo $markup['tag_close']; ?>
                                                </li>
											<?php } ?>

											<?php if ( $key_contact == 'email' ) { ?>
                                                <li>
                                                    <a href="mailto:<?php echo $val; ?>">
                                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 16 16">
                                                            <path d="M8 0a8 8 0 1 0 0 16A8 8 0 0 0 8 0zM4 4h8c.143 0 .281.031.409.088L8 9.231L3.591 4.088A.982.982 0 0 1 4 4zm-1 7V5l.002-.063l2.932 3.421l-2.9 2.9A.967.967 0 0 1 3 11zm9 1H4c-.088 0-.175-.012-.258-.034L6.588 9.12l1.413 1.648L9.414 9.12l2.846 2.846a.967.967 0 0 1-.258.034zm1-1c0 .088-.012.175-.034.258l-2.9-2.9l2.932-3.421L13 5v6z" fill="#626262"></path>
                                                        </svg>
                                                    </a>
                                                </li>
											<?php } ?>
											<?php if ( $key_contact == 'tel' ) { ?>
                                                <li>
                                                    <a href="tel:<?php echo Helper::phone_number_format( $val ); ?>">
                                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 100 100">
                                                            <path fill="#626262"
                                                                  d="M84.96 70.237c-.167-1.032-.814-1.914-1.783-2.438l-14.335-8.446l-.118-.066a4.256 4.256 0 0 0-1.937-.45c-1.201 0-2.348.455-3.144 1.253l-4.231 4.233c-.181.172-.771.421-.95.43c-.049-.004-4.923-.355-13.896-9.329c-8.957-8.955-9.337-13.844-9.34-13.844c.005-.25.251-.838.426-1.02l3.608-3.607c1.271-1.274 1.652-3.386.898-5.022L32.19 16.938c-.579-1.192-1.704-1.928-2.952-1.928c-.883 0-1.735.366-2.401 1.031l-9.835 9.813c-.943.938-1.755 2.578-1.932 3.898c-.086.631-1.831 15.693 18.819 36.346C51.42 83.627 65.09 84.989 68.865 84.989a10.7 10.7 0 0 0 1.376-.071c1.316-.176 2.954-.986 3.891-1.925l9.827-9.826c.802-.806 1.168-1.871 1.001-2.93z"></path>
                                                        </svg>
                                                    </a>
                                                </li>
											<?php } ?>
										<?php } ?>
                                    </ul>
									<?php
								}
								?>
                            </div>
                        </div>
                    </div>
				<?php } ?>
            </div>
        </div>
    </div>
</div>