<?php
$block_enabled = get_theme_mod( 'home_tabs_object_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$title      = get_theme_mod( 'home_tabs_object_title', '' );
$title_type = get_theme_mod( 'home_tabs_object_title_type', 'div' );
$text       = get_theme_mod( 'home_tabs_object_text' );
$tab_items  = get_theme_mod( 'home_tabs_object_items', [] );

$tab_post_ids = [];
foreach ( $tab_items as $item ) {
	if ( $item['post_id'] ) {
		$tab_post_ids[] = $item['post_id'];
	}
}

if ( ! $tab_post_ids ) {
	return;
}

$posts_per_page = count( $tab_post_ids );
$post__in       = $tab_post_ids;
$orderby        = 'post__in';

$service_posts = get_posts( [
	'post_type'        => 'tab_wescle',
	'posts_per_page'   => $posts_per_page,
	'post__in'         => $post__in,
	'orderby'          => $orderby,
	'suppress_filters' => false
] );
if ( ! $service_posts ) {
	return;
}

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_tabs_object_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_tabs_object_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_tabs_object_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="highlight<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_tabs_object_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="highlight__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
		<?php if ( $text ) { ?>
            <div class="highlight__subtitle"><?php echo $text; ?></div>
		<?php } ?>
        <div class="_tabs">
            <ul class="highlight-tabs-nav">
				<?php foreach ( $service_posts as $key => $post_item ) { ?>
					<?php
					$class_active = '';
					if ( $key == 0 ) {
						$class_active = '_active';
					}
					?>
                    <li>
                        <button class="btn btn-main _tabs-item <?php echo $class_active; ?>" type="button"><?php echo $post_item->post_title; ?></button>
                    </li>
				<?php } ?>
            </ul>
            <ul class="highlight-tabs">
				<?php foreach ( $service_posts as $key => $post_item ) { ?>
					<?php
					$class_active = '';
					if ( $key == 0 ) {
						$class_active = '_active';
					}

					$tabs_items = get_post_meta( $post_item->ID, 'wescle_tab_info', 1 );
					?>
                    <li class="_tabs-block _fade <?php echo $class_active; ?>">
                        <div class="highlight-tabs__content">
							<?php foreach ( $tabs_items as $item ) { ?>
								<?php
								$bg_color_style = $item['bg_color'] ? 'style="background-color:' . $item['bg_color'] . '"' : '';
								$tag_open       = '<div class="highlight-tab-item">';
								$tag_close      = '</div>';
								if ( isset( $item['url'] ) && $item['url'] ) {
									$tag_open  = '<a href="' . $item['url'] . '" class="highlight-tab-item">';
									$tag_close = '</a>';
								}
								?>
                                <div class="highlight-tabs__col">
									<?php echo $tag_open; ?>
									<?php if ( $item['img_id'] ) { ?>
                                        <div class="highlight-tab-item__img" <?php echo $bg_color_style; ?>>
											<?php echo wp_get_attachment_image( $item['img_id'] ); ?>
                                        </div>
									<?php } ?>
                                    <div class="highlight-tab-item__body">
										<?php if ( $item['title'] ) { ?>
                                            <div class="highlight-tab-item__title"><?php echo $item['title']; ?></div>
										<?php } ?>
										<?php if ( $item['text'] ) { ?>
                                            <div class="highlight-tab-item__text"><?php echo $item['text']; ?></div>
										<?php } ?>
                                    </div>
									<?php echo $tag_close; ?>
                                </div>
							<?php } ?>
                        </div>
                    </li>
				<?php } ?>
            </ul>
        </div>
    </div>
</div>
