<?php
$block_enabled = get_theme_mod( 'home_stories_enabled', false );
if ( ! $block_enabled ) {
	return;
}

if ( is_front_page() ) {
	if ( ! get_theme_mod( 'home_stories_enabled_home', true ) ) {
		return;
	}
}

$title      = get_theme_mod( 'home_stories_title' );
$title_type = get_theme_mod( 'home_stories_title_type', 'div' );
$text       = get_theme_mod( 'home_stories_text' );
$img_id     = get_theme_mod( 'home_stories_image' );

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_stories_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_stories_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_stories_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="stories-section<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_stories_image_bg' ); ?>
    <div class="container">
		<?php if ( $img_id ) { ?>
            <div class="stories-section__banner banner-block">
                <div class="banner-block__img">
					<?php echo wp_get_attachment_image( $img_id, 'full' ); ?>
                </div>
                <div class="banner-block__body">
					<?php
					if ( $title ) {
						$title = str_replace( '%', '%%', $title );

						printf( '<%1$s class="banner-block__title" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
					}
					?>
					<?php if ( $text ) { ?>
                        <div class="banner-block__text"><?php echo $text; ?></div>
					<?php } ?>
                </div>
            </div>
		<?php } ?>
        <div class="stories-wrapper">
            <div id="stories"></div>
            <div class="stories-pc-nav">
                <button class="stories-pc-nav-prev" type="button">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(180deg); -webkit-transform: rotate(180deg); transform: rotate(180deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                        <g fill="none">
                            <path d="M8 4l8 8l-8 8" stroke="#0088cc" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"></path>
                        </g>
                    </svg>
                </button>
                <button class="stories-pc-nav-next" type="button">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                        <g fill="none">
                            <path d="M8 4l8 8l-8 8" stroke="#0088cc" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"></path>
                        </g>
                    </svg>
                </button>
            </div>
        </div>
    </div>
</div>