<?php
$block_enabled = get_theme_mod( 'home_sta_minimal_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$title        = get_theme_mod( 'home_sta_minimal_title' );
$title_type   = get_theme_mod( 'home_sta_minimal_title_type', 'div' );
$text         = get_theme_mod( 'home_sta_minimal_text' );
$sta_buttons  = get_theme_mod( 'home_sta_minimal_items', [] );
$sta_bg_color = get_theme_mod( 'home_sta_minimal_bg_color', '' );
$sta_bg_image = get_theme_mod( 'home_sta_minimal_bg_image', '' );

$style_stroke_1 = '';
$style_stroke_2 = '';
if ( $image_color_1 = get_theme_mod( 'home_sta_minimal_color_1', '' ) ) {
	$style_stroke_1 = 'style="stroke:' . $image_color_1 . '"';
}
if ( $image_color_2 = get_theme_mod( 'home_sta_minimal_color_2', '' ) ) {
	$style_stroke_2 = 'style="stroke:' . $image_color_2 . '"';
}

$img = '';
if ( $sta_bg_image ) {
	$img = wp_get_attachment_image( $sta_bg_image, 'medium_large' );
}

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_sta_minimal_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_sta_minimal_title_color' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$style_text = '';
if ( $color = get_theme_mod( 'home_sta_minimal_text_color' ) ) {
	$style_text = ' style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_sta_minimal_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="sta-minimal<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_sta_minimal_image_bg' ); ?>
    <div class="sta-minimal-block">
        <div class="container">
            <div class="sta-minimal-block__row">
                <div class="sta-minimal-block__col">
                    <div class="sta-minimal-block__about">
						<?php
						if ( $title ) {
							printf( '<%1$s class="sta-minimal-block__title title" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
						}
						?>
						<?php if ( $text ) { ?>
                            <div class="sta-minimal-block__text"<?php echo $style_text; ?>><?php echo $text; ?></div>
						<?php } ?>
						<?php if ( $sta_buttons ) { ?>
                            <div class="sta-minimal-block__actions">
								<?php foreach ( $sta_buttons as $sta_button ) { ?>
									<?php
									$target       = isset( $sta_button['target_blank'] ) && $sta_button['target_blank'] ? 'target="_blank"' : '';
									$custom_class = '';

									if ( strpos( $sta_button['url'], '#wescle-modal' ) !== false ) {
										$custom_class = '_popup-link';
									}

									if ( ! $custom_class ) {
										if ( ! $sta_button['url'] || $sta_button['url'] == '#' || $sta_button['url'] == '#modal-call' ) {
											$custom_class      = '_popup-link';
											$sta_button['url'] = '#modal-call';
										}
									}

									$btn_flare = '';
									if ( isset( $sta_button['button_view'] ) ) {
										if ( 'bg' == $sta_button['button_view'] ) {
											$btn_flare = 'btn-main_blue ';
										}
                                        elseif ( 'animation' == $sta_button['button_view'] ) {
	                                        $btn_flare = 'btn-main_blue btn-flare ';
										}
									}
									?>
                                    <div class="sta-minimal-block__actions-col">
                                        <a class="btn btn-main <?php echo $btn_flare; ?><?php echo $custom_class; ?>" href="<?php echo $sta_button['url']; ?>" <?php echo $target; ?>>
                                            <span><?php echo $sta_button['title']; ?></span>
                                        </a>
                                    </div>
								<?php } ?>
                            </div>
						<?php } ?>
                    </div>
                </div>
                <div class="sta-minimal-block__col">
                    <div class="sta-minimal-block__img">
						<?php
						if ( $img ) {
							echo $img;
						}
						else { ?>
                            <svg width="380px" height="500px" viewbox="0 0 837 1045" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                    <path class="sta-min-p-1 sta-min-accent" d="M353,9 L626.664028,170 L626.664028,487 L353,642 L79.3359724,487 L79.3359724,170 L353,9 Z" <?php echo $style_stroke_1; ?> stroke-width="6" sketch:type="MSShapeGroup"></path>
                                    <path class="sta-min-p-2 sta-min-secondary" d="M78.5,529 L147,569.186414 L147,648.311216 L78.5,687 L10,648.311216 L10,569.186414 L78.5,529 Z" <?php echo $style_stroke_2; ?> stroke-width="6" sketch:type="MSShapeGroup"></path>
                                    <path class="sta-min-p-3 sta-min-accent" d="M773,186 L827,217.538705 L827,279.636651 L773,310 L719,279.636651 L719,217.538705 L773,186 Z" <?php echo $style_stroke_1; ?> stroke-width="6" sketch:type="MSShapeGroup"></path>
                                    <path class="sta-min-p-4 sta-min-secondary" d="M639,529 L773,607.846761 L773,763.091627 L639,839 L505,763.091627 L505,607.846761 L639,529 Z" <?php echo $style_stroke_2; ?> stroke-width="6" sketch:type="MSShapeGroup"></path>
                                    <path class="sta-min-p-5 sta-min-accent" d="M281,801 L383,861.025276 L383,979.21169 L281,1037 L179,979.21169 L179,861.025276 L281,801 Z" <?php echo $style_stroke_1; ?> stroke-width="6" sketch:type="MSShapeGroup"></path>
                                </g>
                            </svg>
						<?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>