<?php
$block_enabled = get_theme_mod( 'home_sta_center_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$title        = get_theme_mod( 'home_sta_center_title' );
$title_type   = get_theme_mod( 'home_sta_center_title_type', 'div' );
$text         = get_theme_mod( 'home_sta_center_text' );
$sta_buttons  = get_theme_mod( 'home_sta_center_items', [] );
$sta_bg_color = get_theme_mod( 'home_sta_center_bg_color', '' );
$sta_bg_image = get_theme_mod( 'home_sta_center_bg_image', '' );

$styles = [];
if ( $sta_bg_color ) {
	$styles[] = 'background-color:' . $sta_bg_color;
}
$img = '';
if ( $sta_bg_image ) {
	$img = wp_get_attachment_url( $sta_bg_image );
}

$style = '';
if ( $styles ) {
	$style = 'style="' . implode( '; ', $styles ) . '"';
}

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_sta_center_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_sta_center_title_color' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$style_text = '';
if ( $color = get_theme_mod( 'home_sta_center_text_color' ) ) {
	$style_text = ' style="color:' . $color . ';"';
}

$btn_flare = '';
if ( get_theme_mod( 'sta_button_type' ) == 'animation' ) {
	$btn_flare = 'btn-flare ';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_sta_center_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="sta-centered<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_sta_center_image_bg' ); ?>
    <div class="container">
        <div class="sta-centered-block" <?php echo $style; ?>>
			<?php if ( $sta_bg_image ) { ?>
                <div class="sta-centered-block__img"><?php echo wp_get_attachment_image( $sta_bg_image, 'full' ); ?></div>
			<?php } ?>
            <div class="sta-centered-block__body">
				<?php
				if ( $title ) {
					printf( '<%1$s class="sta-centered-block__title title" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
				}
				?>
				<?php if ( $text ) { ?>
                    <div class="sta-centered-block__text"<?php echo $style_text; ?>><?php echo $text; ?></div>
				<?php } ?>

				<?php if ( $sta_buttons ) { ?>
                    <div class="sta-centered-block__actions">
						<?php foreach ( $sta_buttons as $sta_button ) { ?>
							<?php
							$target       = isset( $sta_button['target_blank'] ) && $sta_button['target_blank'] ? 'target="_blank"' : '';
							$custom_class = '';

							if ( strpos( $sta_button['url'], '#wescle-modal' ) !== false ) {
								$custom_class = '_popup-link';
							}

							if ( ! $custom_class ) {
								if ( ! $sta_button['url'] || $sta_button['url'] == '#' || $sta_button['url'] == '#modal-call' ) {
									$custom_class      = '_popup-link';
									$sta_button['url'] = '#modal-call';
								}
							}
							?>
                            <a class="btn btn-main <?php echo $btn_flare; ?><?php echo $custom_class; ?>" href="<?php echo $sta_button['url']; ?>" <?php echo $target; ?>>
                                <span><?php echo $sta_button['title']; ?></span>
                            </a>
						<?php } ?>
                    </div>
				<?php } ?>
            </div>
        </div>
    </div>
</div>