<?php
$block_enabled = get_theme_mod( 'home_special_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$title      = get_theme_mod( 'home_special_title' );
$title      = str_replace( '%', '%%', $title );
$title_type = get_theme_mod( 'home_special_title_type', 'div' );
$text       = get_theme_mod( 'home_special_text' );

$home_special_action_label     = get_theme_mod( 'home_special_action_label', Helper::get_default_theme_data( 'home_special_action_label' ) );
$home_special_action_date      = get_theme_mod( 'home_special_action_date' );
$home_special_action_hours     = get_theme_mod( 'home_special_action_hours', 10 );
$home_special_progress_percent = get_theme_mod( 'home_special_progress_percent', Helper::get_default_theme_data( 'home_special_progress_percent' ) );
$home_special_progress_label   = get_theme_mod( 'home_special_progress_label', Helper::get_default_theme_data( 'home_special_progress_label' ) );
$home_special_cf7_position     = get_theme_mod( 'home_special_cf7_position' ) == 'right' ? 'reverse' : '';
$home_special_cf7              = get_theme_mod( 'home_special_cf7' );

if ( get_theme_mod( 'home_special_action_type', 'date' ) == 'date' ) {
	$timer_data_attr = 'data-timer-stop="' . $home_special_action_date . 'T23:59:59"';
}
else {
	$timer_data_attr = 'data-timer-by="' . $home_special_action_hours . '"';
}

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_special_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_special_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_special_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="time-left<?php echo $section_class; ?>" id="time-left" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_special_image_bg' ); ?>
    <div class="container">
        <div class="time-left__grid <?php echo $home_special_cf7_position; ?>">
            <div class="time-left-form">
				<?php
				if ( $home_special_cf7 ) {
					echo do_shortcode( '[contact-form-7 id="' . $home_special_cf7 . '"]' );
				}
				?>
            </div>
            <div class="time-left-info">
				<?php
				if ( $title ) {
					printf( '<%1$s class="time-left__title title title_divider title_center" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
				}
				?>
				<?php echo $text; ?>
                <div class="timer-block" id="timer-block">
					<?php if ( $home_special_action_date ) { ?>
						<?php if ( $home_special_action_label ) { ?>
                            <div class="timer-block__title"><?php echo $home_special_action_label; ?></div>
						<?php } ?>
                        <div class="timer-block__time" id="timer-deadline" <?php echo $timer_data_attr; ?>>
                            <div class="timer-block__item"><span id="days" data-days="">00</span><span class="timer-block__name"><?php _ex( 'дней', 'timer', 'wescle' ); ?></span></div>
                            <div class="timer-block__separator"></div>
                            <div class="timer-block__item"><span id="hours" data-hours="">00</span><span class="timer-block__name"><?php _ex( 'часов', 'timer', 'wescle' ); ?></span></div>
                            <div class="timer-block__separator"></div>
                            <div class="timer-block__item"><span id="minutes" data-minutes="">00</span><span class="timer-block__name"><?php _ex( 'минут', 'timer', 'wescle' ); ?></span></div>
                            <div class="timer-block__separator"></div>
                            <div class="timer-block__item"><span id="seconds" data-seconds="">00</span><span class="timer-block__name"><?php _ex( 'секунд', 'timer', 'wescle' ); ?></span></div>
                        </div>
                        <div class="timer-block__progress">
							<?php if ( $home_special_progress_percent ) { ?>
                                <div class="timer-block__progress-wrap">
                                    <div class="timer-block__progress-line" data-progress-percent="<?php echo $home_special_progress_percent; ?>"></div>
                                </div>
							<?php } ?>
							<?php if ( $home_special_progress_label ) { ?>
                                <div class="timer-block__progress-about"><?php echo $home_special_progress_label; ?></div>
							<?php } ?>
                        </div>
					<?php } ?>
                </div>
            </div>
        </div>
    </div>
</div>