<?php
$block_enabled = get_theme_mod( 'home_services_slider_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$title      = get_theme_mod( 'home_services_slider_title' );
$title_type = get_theme_mod( 'home_services_slider_title_type', 'div' );
$text       = get_theme_mod( 'home_services_slider_text' );
$link       = '';
$link_id    = get_theme_mod( 'home_services_slider_link_id', 0 );
if ( $link_id ) {
	$link = get_permalink( $link_id );
}
$link_text                  = get_theme_mod( 'home_services_slider_link_text' );
$home_services_slider_posts = get_theme_mod( 'home_services_slider_posts', [] );

$services_post_ids = [];
foreach ( $home_services_slider_posts as $item ) {
	if ( $item['post_id'] ) {
		$post_id = apply_filters( 'wpml_object_id', $item['post_id'], 'service', true );

		$services_post_ids[] = $post_id;
	}
}

$posts_per_page = 4;
$post__in       = [];
$orderby        = 'date';
if ( $services_post_ids ) {
	$posts_per_page = count( $services_post_ids );
	$post__in       = $services_post_ids;
	$orderby        = 'post__in';
}

$service_posts = get_posts( [
	'post_type'        => 'service',
	'posts_per_page'   => $posts_per_page,
	'post__in'         => $post__in,
	'orderby'          => $orderby,
	'suppress_filters' => false
] );
if ( ! $service_posts ) {
	return;
}

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_services_slider_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_services_slider_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$slides_count         = get_theme_mod( 'home_services_slider_settings_count', 3 );
$slider_speed         = get_theme_mod( 'home_services_slider_settings_speed', 5 );
$slider_speed         = $slider_speed * 1000;
$slider_dots          = get_theme_mod( 'home_services_slider_settings_dots', true ) == true ? 'true' : 'false';
$slider_arrows        = get_theme_mod( 'home_services_slider_settings_arrow', true ) == true ? 'true' : 'false';
$slider_arrows_mobile = get_theme_mod( 'home_services_slider_settings_arrow_mobile', true ) == true ? '' : '_hide-arrows-mobile';

$section_class    = '';
$section_position = get_theme_mod( 'home_services_slider_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="additional-services<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_services_slider_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="additional-services__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
        <div class="slider-wrapper">
            <div class="additional-services__header _section-about">
				<?php if ( $text ) { ?>
                    <div class="additional-services__about">
                        <div class="additional-services__text"><?php echo $text; ?></div>
                    </div>
				<?php } ?>
				<?php if ( $link && $link_text ) { ?>
                    <a class="additional-services__link" href="<?php echo $link; ?>"><?php echo esc_html( $link_text ); ?></a>
				<?php } ?>
                <div class="additional-services__buttons slider-buttons">
                    <button class="slider-buttons__item slider-buttons__item_prev" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(180deg); -webkit-transform: rotate(180deg); transform: rotate(180deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                            <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                        </svg>
                    </button>
                    <button class="slider-buttons__item slider-buttons__item_next" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                            <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                        </svg>
                    </button>
                </div>
            </div>
            <div class="additional-services__slider" data-slides="<?php echo $slides_count; ?>" data-autoplay-speed="<?php echo $slider_speed; ?>" data-dots="<?php echo $slider_dots; ?>" data-arrows="<?php echo $slider_arrows; ?>">
				<?php
				foreach ( $service_posts as $post ) {
					setup_postdata( $post );

					get_template_part( 'template-parts/content/service_slider', 'item' );
				}
				wp_reset_postdata();
				?>
            </div>
        </div>
    </div>
</div>