<?php
$block_enabled = get_theme_mod( 'home_services2_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$title      = get_theme_mod( 'home_services2_title', Helper::get_default_theme_data( 'home_services2_title' ) );
$title_type = get_theme_mod( 'home_services2_title_type', 'div' );
$text       = get_theme_mod( 'home_services2_text' );

$home_services_items = get_theme_mod( 'home_services2_items', [] );
if ( ! $home_services_items ) {
	return;
}

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_services2_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_services2_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_services2_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="services-v2<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_services2_image_bg' ); ?>
    <div class="container">
        <div class="services-v2__grid">
            <div class="services-v2-item">
		        <?php
		        if ( $title ) {
			        printf( '<%1$s class="services-v2__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		        }
		        ?>
		        <?php if ( $text ) { ?>
                    <div class="services-v2-item__text"><?php echo $text; ?></div>
		        <?php } ?>
            </div>
	        <?php foreach ( $home_services_items as $key => $item ) { ?>
                <div class="services-v2-item">
			        <?php if ( $item['image'] ) { ?>
                        <div class="services-v2-item__img services-v2-item__<?php echo $key; ?>">
					        <?php echo wp_get_attachment_image( $item['image'], 'medium' ); ?>
                        </div>
			        <?php } ?>
                    <div class="services-v2-item__title"><?php echo $item['title']; ?></div>
                    <div class="services-v2-item__text"><?php echo $item['text']; ?></div>
                </div>
	        <?php } ?>
        </div>
    </div>
</div>