<?php
$block_enabled = get_theme_mod( 'home_services_enabled', false );
if ( ! $block_enabled ) {
	return;
}

if ( is_front_page() ) {
	if ( ! get_theme_mod( 'home_services_enabled_home', true ) ) {
		return;
	}
}

$title      = get_theme_mod( 'home_services_title', Helper::get_default_theme_data( 'home_services_title' ) );
$title_type = get_theme_mod( 'home_services_title_type', 'div' );
$text       = get_theme_mod( 'home_services_text' );
$link       = '';
$link_id    = get_theme_mod( 'home_services_link_id', 0 );
if ( $link_id ) {
	$link = get_permalink( $link_id );
}
$button_text         = get_theme_mod( 'home_services_button_text', Helper::get_default_theme_data( 'home_services_button_text' ) );
$link_text           = get_theme_mod( 'home_services_link_text', Helper::get_default_theme_data( 'home_services_link_text' ) );
$home_services_posts = get_theme_mod( 'home_services_posts', [] );

$services_post_ids  = [];
$home_services_data = [];
foreach ( $home_services_posts as $item ) {
	if ( $item['post_id'] ) {
		$post_id = apply_filters( 'wpml_object_id', $item['post_id'], 'service', true );

		$services_post_ids[] = $post_id;

		$item_price = $item['price'];
		if ( ! $item_price ) {
			$item_price = get_post_meta( $post_id, 'price', 1 );
		}

		$item_price_old = isset( $item['price_old'] ) ? $item['price_old'] : '';
		if ( ! $item_price_old ) {
			$item_price_old = get_post_meta( $post_id, 'price_old', 1 );
		}

		$home_services_data[ $post_id ]['size']      = $item['size'];
		$home_services_data[ $post_id ]['price']     = $item_price;
		$home_services_data[ $post_id ]['price_old'] = $item_price_old;
	}
}

$posts_per_page = 4;
$post__in       = [];
$orderby        = 'date';
if ( $services_post_ids ) {
	$posts_per_page = count( $services_post_ids );
	$post__in       = $services_post_ids;
	$orderby        = 'post__in';
}

$service_posts = get_posts( [
	'post_type'        => 'service',
	'posts_per_page'   => $posts_per_page,
	'post__in'         => $post__in,
	'orderby'          => $orderby,
	'suppress_filters' => false
] );
if ( ! $service_posts ) {
	return;
}

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_services_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_services_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$btn_flare = '';
if ( get_theme_mod( 'services_button_type' ) == 'animation' ) {
	$btn_flare = 'btn-flare ';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_services_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}

if ( get_theme_mod( 'home_services_as_horizontal' ) ) {
	$section_class .= ' _horizontal';
}

?>
<div class="services<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_services_image_bg' ); ?>
    <div class="container">
        <div class="services__top">
			<?php
			if ( $title ) {
				printf( '<%1$s class="services__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
			<?php if ( $link && $link_text ) { ?>
                <a class="services__link" href="<?php echo $link; ?>"><?php echo esc_html( $link_text ); ?></a>
			<?php } ?>
        </div>
        <div class="row services__row">
			<?php if ( $text ) { ?>
                <div class="col services__col services__col_about">
                    <div class="services__about">
						<?php
						$text = str_replace( [ '<p>', '</p>' ], [ '<div class="services__text">', '</div>' ], wpautop( $text ) );
						$text = str_replace( [ '<ul>', '<ol>' ], [ '<ul class="services__text">', '<ol class="services__text">' ], $text );
						echo $text;
						?>

						<?php if ( $link && $button_text ) { ?>
                            <a class="services__btn btn btn-main <?php echo $btn_flare; ?>" href="<?php echo $link; ?>"><?php echo esc_html( $button_text ); ?></a>
						<?php } ?>
                    </div>
                </div>
			<?php } ?>
            <div class="col services__col services__col_items">
                <div class="row services-items">
					<?php
					set_query_var( 'template_args', [ 'services_data' => $home_services_data ] );

					foreach ( $service_posts as $post ) {
						setup_postdata( $post );

						get_template_part( 'template-parts/content/service', 'item' );
					}
					wp_reset_postdata();
					?>
                </div>
            </div>
        </div>
    </div>
</div>