<?php
$block_enabled = get_theme_mod( 'home_seo_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$title      = get_theme_mod( 'home_seo_title' );
$title_type = get_theme_mod( 'home_seo_title_type', 'div' );
$text       = get_theme_mod( 'home_seo_text' );
$height     = get_theme_mod( 'home_seo_height', 250 );
$text_open  = get_theme_mod( 'home_seo_text_open', Helper::get_text_label( 'open' ) );
$text_close = get_theme_mod( 'home_seo_text_close', Helper::get_text_label( 'close' ) );

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_seo_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_seo_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_seo_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="seo section-paddings<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="seo__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
        <div class="seo__text"><?php echo $text; ?></div>
        <button class="btn_expand js-hide" type="button" data-text-open="<?php echo $text_open; ?>" data-text-close="<?php echo $text_close; ?>" data-height="<?php echo $height; ?>">
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                <g fill="none">
                    <path d="M4 9l8 8l8-8" stroke="#626262" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"></path>
                </g>
            </svg>
            <span><?php echo $text_open; ?></span>
        </button>
    </div>
</div>