<?php
$block_enabled = get_theme_mod( 'home_reviews_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$review_post_ids = get_theme_mod( 'home_reviews_posts', [] );

$title      = get_theme_mod( 'home_reviews_title', __( 'Отзывы клиентов', 'wescle' ) );
$title_type = get_theme_mod( 'home_reviews_title_type', 'div' );
$link_id    = get_theme_mod( 'home_reviews_link_id', 0 );
if ( $link_id ) {
	$link = get_permalink( $link_id );
}
$link_text   = get_theme_mod( 'home_reviews_link_text', __( 'Все отзывы', 'wescle' ) );
$button_text = get_theme_mod( 'home_reviews_button_text', __( 'Подробнее', 'wescle' ) );

$orderby = get_theme_mod( 'home_reviews_orderby', 'date' );

$posts_per_page = 10;
$post__in       = [];
if ( $review_post_ids ) {
	$posts_per_page = count( $review_post_ids );
	$post__in       = $review_post_ids;
}

$review_posts = get_posts( [
	'post_type'        => 'review',
	'posts_per_page'   => $posts_per_page,
	'post__in'         => $post__in,
	'orderby'          => $orderby,
	'suppress_filters' => false
] );
if ( ! $review_posts ) {
	return;
}

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_reviews_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_reviews_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$btn_flare = '';
if ( get_theme_mod( 'reviews_button_type' ) == 'animation' ) {
	$btn_flare = 'btn-flare ';
}

$slider_speed         = get_theme_mod( 'home_reviews_settings_speed', 8 );
$slider_speed         = $slider_speed * 1000;
$slider_dots          = get_theme_mod( 'home_reviews_settings_dots', false ) == true ? 'true' : 'false';
$slider_arrows        = get_theme_mod( 'home_reviews_settings_arrow', true ) == true ? 'true' : 'false';
$slider_arrows_mobile = get_theme_mod( 'home_reviews_settings_arrow_mobile', true ) == true ? '' : '_hide-arrows-mobile';

$section_class    = '';
$section_position = get_theme_mod( 'home_reviews_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="reviews<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_reviews_image_bg' ); ?>
    <div class="container">
        <div class="slider-wrapper <?php echo $slider_arrows_mobile; ?>">
			<?php
			if ( $title ) {
				printf( '<%1$s class="reviews__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
            <div class="reviews__top">
				<?php if ( $link_id && $link_text ) { ?>
                    <a class="reviews__link" href="<?php echo $link; ?>"><?php echo esc_html( $link_text ); ?></a>
				<?php } ?>
                <div class="reviews__buttons slider-buttons">
                    <button class="slider-buttons__item slider-buttons__item_prev" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(180deg); -webkit-transform: rotate(180deg); transform: rotate(180deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                            <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                        </svg>
                    </button>
                    <button class="slider-buttons__item slider-buttons__item_next" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                            <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                        </svg>
                    </button>
                </div>
            </div>
            <div class="reviews__body">
                <div class="reviews__slider reviews-slider" data-autoplay-speed="<?php echo $slider_speed; ?>" data-dots="<?php echo $slider_dots; ?>" data-arrows="<?php echo $slider_arrows; ?>">
					<?php
					foreach ( $review_posts as $post ) {
						setup_postdata( $post );
						?>
                        <div class="reviews-slider__slide">
							<?php get_template_part( 'template-parts/content/review', 'item', [ 'button_text' => $button_text, 'btn_flare' => $btn_flare ] ); ?>
                        </div>
						<?php
					}
					wp_reset_postdata();
					?>
                </div>
            </div>
        </div>
    </div>
</div>