<?php
$block_enabled = get_theme_mod( 'home_pros_cons_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$title       = get_theme_mod( 'home_pros_cons_title' );
$title_type  = get_theme_mod( 'home_pros_cons_title_type', 'div' );
$plus_items  = get_theme_mod( 'home_pros_cons_plus', [] );
$minus_items = get_theme_mod( 'home_pros_cons_minus', [] );

$style_inner_bg = '';
if ( $color_bg = get_theme_mod( 'home_pros_cons_inner_bg' ) ) {
	$style_inner_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_pros_cons_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_pros_cons_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_pros_cons_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="plus-minus<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_pros_cons_image_bg' ); ?>
    <div class="container">
        <div class="plus-minus__content" <?php echo $style_inner_bg; ?>>
			<?php
			if ( $title ) {
				printf( '<%1$s class="plus-minus__title title" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
            <div class="plus-minus__grid">
                <ul class="plus-minus__pluses">
					<?php foreach ( $plus_items as $item ) { ?>
						<?php if ( $item['text'] ) { ?>
                            <li><img width="15" height="15" src="<?php echo get_template_directory_uri(); ?>/assets/img/svg/plus.svg" alt="plus icon" loading="lazy">
                                <p><?php echo nl2br( $item['text'] ); ?></p>
                            </li>
						<?php } ?>
					<?php } ?>
                </ul>
                <ul class="plus-minus__minuses">
					<?php foreach ( $minus_items as $item ) { ?>
						<?php if ( $item['text'] ) { ?>
                            <li><img width="15" height="15" src="<?php echo get_template_directory_uri(); ?>/assets/img/svg/minus.svg" alt="plus icon" loading="lazy">
                                <p><?php echo nl2br( $item['text'] ); ?></p>
                            </li>
						<?php } ?>
					<?php } ?>
                </ul>
            </div>
        </div>
    </div>
</div>


