<?php
$slider_layout = get_theme_mod( 'slider_layout', 'columns_two' );

$data_arrows         = '';
$autoplay_speed      = get_theme_mod( 'slider_autoplay_speed', '8' );
$data_autoplay_speed = 'data-autoplay-speed="' . ( $autoplay_speed * 1000 ) . '"';

if ( in_array( $slider_layout, [ 'columns_two', 'columns_one', 'columns_four', 'banner', 'store' ] ) ) {
	$data_dots   = get_theme_mod( 'slider_dots', 'true' ) ? 'true' : 'false';
	$data_arrows = get_theme_mod( 'slider_arrows', 'false' ) ? 'true' : 'false';

	$data_autoplay_speed .= ' data-dots="' . $data_dots . '" data-arrows="' . $data_arrows . '"';
}

if ( in_array( $slider_layout, [ 'columns_two', 'columns_one', 'columns_four' ] ) ) {
	$key_layout = 'columns_two';

	$post_card_meta = [];
	foreach ( choices_visibility_meta() as $key => $val ) {
		$post_card_meta[ $key ] = $key;
	}

	foreach ( choices_visibility_meta() as $key => $val ) {
		if ( ! get_theme_mod( 'slider_' . $key_layout . '_visibility_' . $key, true ) ) {
			unset( $post_card_meta[ $key ] );
		}
	}

	$post_card_order = get_theme_mod( 'slider_' . $key_layout . '_meta', [ 'category', 'title', 'meta' ] );

	$posts_per_page = intval( get_theme_mod( 'slider_columns_two_limit', 8 ) );
	if ( ! $posts_per_page ) {
		$posts_per_page = 8;
	}

	$args = [
		'post_type'        => 'post',
		'posts_per_page'   => $posts_per_page,
		'tax_query'        => [],
		'post__in'         => '',
		'suppress_filters' => false
	];

	$cat_include   = get_theme_mod( 'slider_columns_two_category', [] );
	$posts_include = get_theme_mod( 'slider_columns_two_posts', [] );

	if ( $posts_include && $posts_include[0] ) {
		$args['post__in']       = $posts_include;
		$args['orderby']        = [ 'menu_order' => 'ASC', 'date' => 'DESC' ];
		$args['posts_per_page'] = count( $posts_include );
	}
	elseif ( $cat_include && $cat_include[0] ) {
		$args['tax_query'][] = [
			'taxonomy' => 'category',
			'terms'    => $cat_include,
		];
	}

	$args            = apply_filters( 'promo_slider_args', $args, $slider_layout );
	$posts_in_slider = get_posts( $args );
	if ( $posts_in_slider ) {
		$template_args = [
			'posts_in_slider'     => $posts_in_slider,
			'post_card_order'     => $post_card_order,
			'post_card_meta'      => $post_card_meta,
			'data_autoplay_speed' => $data_autoplay_speed,
			'data_arrows'         => $data_arrows,
			'content_box'         => get_theme_mod( 'content_box', 'box' ),
			'is_fullwidth'        => get_theme_mod( 'slider_columns_fullwidth', false ),
			'color_bg'            => get_theme_mod( 'home_slider_carousel_color_bg' ),
			'without_gradient'    => get_theme_mod( 'slider_image_without_gradient', false ),
		];

		set_query_var( 'template_args', $template_args );
		get_template_part( 'template-parts/home/promo', $slider_layout );
	}
}
elseif ( in_array( $slider_layout, [ 'columns_one_two', 'columns_one_four' ] ) ) {
	$left_key  = 'left_block';
	$right_key = 'right_block';

	$left_post_card_meta  = [];
	$right_post_card_meta = [];
	foreach ( choices_visibility_meta() as $key => $val ) {
		$left_post_card_meta[ $key ]  = $key;
		$right_post_card_meta[ $key ] = $key;
	}

	foreach ( choices_visibility_meta() as $key => $val ) {
		if ( ! get_theme_mod( 'slider_' . $left_key . '_visibility_' . $key, true ) ) {
			unset( $left_post_card_meta[ $key ] );
		}
	}

	foreach ( choices_visibility_meta() as $key => $val ) {
		if ( ! get_theme_mod( 'slider_' . $right_key . '_visibility_' . $key, true ) ) {
			unset( $right_post_card_meta[ $key ] );
		}
	}

	$left_post_card_order  = get_theme_mod( 'slider_' . $left_key . '_meta', [ 'category', 'title', 'meta' ] );
	$right_post_card_order = get_theme_mod( 'slider_' . $right_key . '_meta', [ 'category', 'title', 'meta' ] );

	/* POSTS in left Column */
	$left_args = [
		'post_type'        => 'post',
		'posts_per_page'   => 1,
		'tax_query'        => [],
		'post__in'         => '',
		'orderby'          => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
		'suppress_filters' => false
	];

	$cat_include   = get_theme_mod( 'slider_' . $left_key . '_category', [] );
	$posts_include = get_theme_mod( 'slider_' . $left_key . '_category_posts', [] );

	if ( $posts_include && $posts_include[0] ) {
		$left_args['post__in']       = $posts_include;
		$left_args['posts_per_page'] = count( $posts_include );
	}
	elseif ( $cat_include && $cat_include[0] ) {
		$left_args['tax_query'][] = [
			'taxonomy' => 'category',
			'terms'    => $cat_include,
		];
	}

	$left_args        = apply_filters( 'promo_' . $left_key . '_args', $left_args, $slider_layout );
	$posts_left_block = get_posts( $left_args );


	/* POSTS in right Column */
	$right_args = [
		'post_type'        => 'post',
		'posts_per_page'   => 4,
		'tax_query'        => [],
		'post__in'         => '',
		'orderby'          => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
		'suppress_filters' => false
	];

	$cat_include   = get_theme_mod( 'slider_' . $right_key . '_category', [] );
	$posts_include = get_theme_mod( 'slider_' . $right_key . '_category_posts', [] );
	$offset        = get_theme_mod( 'slider_' . $right_key . '_offset', 0 );

	if ( $posts_include && $posts_include[0] ) {
		$right_args['post__in']       = $posts_include;
		$right_args['posts_per_page'] = count( $posts_include );
	}
	elseif ( $cat_include && $cat_include[0] ) {
		$right_args['tax_query'][] = [
			'taxonomy' => 'category',
			'terms'    => $cat_include,
		];

		if ( isset( $left_args['tax_query'] ) && isset( $left_args['tax_query'][0]['terms'] ) && $left_args['tax_query'][0]['terms'] ) {
			foreach ( $cat_include as $cat_id ) {
				if ( in_array( $cat_id, $left_args['tax_query'][0]['terms'] ) ) {
					$right_args['offset'] = 1;
				}
			}
		}
	}

	if ( $offset ) {
		$right_args['offset'] = intval( $offset );
	}

	$right_args        = apply_filters( 'promo_' . $right_key . '_args', $right_args, $slider_layout );
	$posts_right_block = get_posts( $right_args );

	if ( $posts_left_block && $posts_right_block ) {
		$template_args = [
			'left_posts_in_slider' => $posts_left_block,
			'left_post_card_order' => $left_post_card_order,
			'left_post_card_meta'  => $left_post_card_meta,

			'right_posts_in_slider' => $posts_right_block,
			'right_post_card_order' => $right_post_card_order,
			'right_post_card_meta'  => $right_post_card_meta,

			'content_box'      => get_theme_mod( 'content_box', 'box' ),
			'color_bg'         => get_theme_mod( 'home_slider_carousel_color_bg' ),
			'without_gradient' => get_theme_mod( 'slider_image_without_gradient', false ),
		];

		set_query_var( 'template_args', $template_args );
		get_template_part( 'template-parts/home/promo', $slider_layout );
	}
}
elseif ( in_array( $slider_layout, [ 'banner' ] ) ) {
	$template_args = [
		'slides'              => get_theme_mod( 'slider_banner' ),
		'data_autoplay_speed' => $data_autoplay_speed,
		'data_arrows'         => $data_arrows,
		'content_box'         => get_theme_mod( 'content_box', 'box' ),
		'h1_on'               => get_theme_mod( 'slider_banner_title_is_h1', false ),
		'color_bg'            => get_theme_mod( 'home_slider_carousel_color_bg' ),
		'is_fullwidth'        => get_theme_mod( 'slider_banner_fullwidth', false ),
		'without_gradient'    => get_theme_mod( 'slider_image_without_gradient', false ),
		'slider_effect' => get_theme_mod( 'slider_banner_slider_effect' ) === 'fade' ? 'data-fade="true"' : ''
	];

	set_query_var( 'template_args', $template_args );
	get_template_part( 'template-parts/home/promo', 'banner' );
}
elseif ( 'store' == $slider_layout && Helper::is_woocommerce_active() ) {
	$slides_data = [
		'one' => [],
		'two' => [],
	];

	foreach ( [ 'one', 'two' ] as $key ) {
		$slides     = [];
		$size_image = 'medium_large';
		if ( 'one' == $key ) {
			$size_image = 'medium_large';
			if ( ! get_theme_mod( 'slider_store_menu_enabled', true ) || 'default' == get_theme_mod( 'content_box', 'box' ) || ! get_theme_mod( 'slider_store_two_enabled', true ) ) {
				$size_image = 'large';
			};
			if ( ! get_theme_mod( 'slider_store_menu_enabled', true ) && ! get_theme_mod( 'slider_store_two_enabled', true ) ) {
				$size_image = 'full';
			}
		}

		if ( 'two' == $key ) {
			if ( ! get_theme_mod( 'slider_store_' . $key . '_enabled', true ) ) {
				continue;
			}
		}

		$type = get_theme_mod( 'slider_store_' . $key . '_type', 'custom' );
		if ( 'product' == $type ) {
			$button_label = '';
			if ( 'one' == $key ) {
				$button_label = get_theme_mod( 'slider_store_' . $key . '_button_label', Helper::get_default_theme_data( 'slider_store_' . $key . '_button_label' ) );
			}

			$limit = get_theme_mod( 'slider_store_' . $key . '_limit', 6 );
			if ( $limit < 1 ) {
				$limit = 6;
			}
			$product_args = [
				'post_type'        => 'product',
				'posts_per_page'   => $limit,
				'tax_query'        => [],
				'orderby'          => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
				'suppress_filters' => false
			];

			$product_cats = get_theme_mod( 'slider_store_' . $key . '_category' );
			if ( $product_cats && $product_cats[0] ) {
				$product_args['tax_query'][] = [
					'taxonomy' => 'product_cat',
					'terms'    => $product_cats
				];
			}

			$product_ids = get_theme_mod( 'slider_store_' . $key . '_products' );
			if ( $product_ids && $product_ids[0] ) {
				unset( $product_args['tax_query'] );

				$product_args['posts_per_page'] = count( $product_ids );
				$product_args['post__in']       = $product_ids;
			}

			$posts_product = get_posts( apply_filters( 'slider_store_' . $key . '_products_args', $product_args ) );
			foreach ( $posts_product as $post ) {
				setup_postdata( $post );
				global $product;

				$slides[] = [
					'image_html'    => $product->get_image( $size_image ),
					'category_html' => ( 'one' == $key ) ? str_replace( '<a', '<a class="category"', wc_get_product_category_list( $product->get_id(), ' ', '', '' ) ) : '',
					'title'         => get_the_title(),
					'text'          => '',
					'link'          => get_permalink(),
					'price'         => $product->is_type( 'simple' ) ? wc_price( $product->get_price() ) : $product->get_price_html(),
					'price_old'     => $product->is_on_sale() && $product->get_sale_price() ? wc_price( $product->get_regular_price() ) : '',
					'button_label'  => $button_label,
				];
			}
			wp_reset_postdata();
		}
		elseif ( 'custom' == $type ) {
			$custom_items = get_theme_mod( 'slider_store_' . $key . '_slides', [] );
			foreach ( $custom_items as $custom_item ) {
				if ( $img_id = $custom_item['image'] ) {
					$image     = wp_get_attachment_image( $img_id, $size_image );
					$image_url = wp_get_attachment_image_src( $img_id, $size_image )[0];
				}
				else {
					$image     = wc_placeholder_img( $size_image, [ 'loading' => 'lazy' ] );
					$image_url = wp_get_attachment_url( get_option( 'woocommerce_placeholder_image', 0 ) );
				}

				if ( $key == 'one' ) {
					$woo_text_h_align = $custom_item['woo_text_h_align'] ?? '';
					$woo_text_v_align = $custom_item['woo_text_v_align'] ?? '';
				}
				elseif ( $key == 'two' ) {
					$woo_text_h_align = $custom_item['woo2_text_h_align'] ?? '';
					$woo_text_v_align = $custom_item['woo2_text_v_align'] ?? '';
				}

				$slides[] = [
					'image_html'       => $image,
					'image_url'        => $image_url,
					'category_html'    => '',
					'title'            => $custom_item['title'],
					'text'             => $custom_item['text'] ?? '',
					'link'             => $custom_item['button_url'],
					'price'            => $custom_item['price'],
					'price_old'        => $custom_item['price_old'],
					'button_label'     => $custom_item['button_label'] ?? '',
					'button_label2'    => $custom_item['button_label_new'] ?? '',
					'button_url2'      => $custom_item['button_url_new'] ?? '',
					'woo_text_h_align' => $woo_text_h_align,
					'video'            => $custom_item['video'] ?? '',
					'video_yt'         => $custom_item['video_yt'] ?? '',
					'video_autoplay'   => $custom_item['video_autoplay'] ?? '',
					'video_loop'       => $custom_item['video_loop'] ?? '',
					'video_control'    => $custom_item['video_control'] ?? '',
				];
			}
		}

		$slides_data[ $key ] = $slides;
	}

	$template_args = [
		'slides'              => $slides_data,
		'data_autoplay_speed' => $data_autoplay_speed,
		'data_arrows'         => $data_arrows,
		'menu_enabled'        => get_theme_mod( 'slider_store_menu_enabled', true ),
		'slider_two_enabled'  => get_theme_mod( 'slider_store_two_enabled', true ),
		'content_box'         => get_theme_mod( 'content_box', 'box' ),
		'h1_on'               => get_theme_mod( 'slider_banner_title_is_h1', false ),
		'color_bg'            => get_theme_mod( 'home_slider_carousel_color_bg' ),
		'without_gradient'    => get_theme_mod( 'slider_image_without_gradient', false ),
		'is_fullwidth'        => get_theme_mod( 'slider_store_one_fullwidth', false )
	];
	set_query_var( 'template_args', $template_args );
	get_template_part( 'template-parts/home/promo', $slider_layout );
}
elseif ( 'animated' == $slider_layout ) {
	$template_args = [
		'color_bg'                  => get_theme_mod( 'animated_color_bg' ),
		'btn_flare'                 => ( get_theme_mod( 'banner_button_type' ) === 'animation' ) ? 'btn-flare' : '',
		'animated_label_text'       => get_theme_mod( 'animated_label_text' ),
		'animated_label_href'       => get_theme_mod( 'animated_label_href' ),
		'animated_title_1'          => get_theme_mod( 'animated_title_1' ),
		'animated_title_type'       => get_theme_mod( 'animated_title_type', 'div' ),
		'animated_title_text_items' => get_theme_mod( 'animated_title_text_items', [] ),
		'animated_title_2'          => get_theme_mod( 'animated_title_2' ),
		'animated_title_3'          => get_theme_mod( 'animated_title_3' ),
		'animated_buttons'          => get_theme_mod( 'animated_buttons', [] ),
		'animated_advantages'       => get_theme_mod( 'animated_advantages', [] ),
		'animated_bg_image_1'       => get_theme_mod( 'animated_bg_image_1' ),
		'animated_bg_image_2'       => get_theme_mod( 'animated_bg_image_2' ),
		'animated_play_label'       => get_theme_mod( 'animated_play_label' ),
		'animated_video_href'       => get_theme_mod( 'animated_video_href' ),
	];
	set_query_var( 'template_args', $template_args );
	get_template_part( 'template-parts/home/promo', $slider_layout );
}
elseif ( 'parallax' == $slider_layout ) {
	$template_args = [
		'color_bg'                   => get_theme_mod( 'parallax_color_bg' ),
		'btn_flare'                  => ( get_theme_mod( 'banner_button_type' ) === 'animation' ) ? 'btn-flare' : '',
		'parallax_label_text'        => get_theme_mod( 'parallax_label_text' ),
		'parallax_title_1'           => get_theme_mod( 'parallax_title_1' ),
		'parallax_title_type'        => get_theme_mod( 'parallax_title_type', 'div' ),
		'parallax_text_items'        => get_theme_mod( 'parallax_text_items', [] ),
		'parallax_button_label'      => get_theme_mod( 'parallax_button_label' ),
		'parallax_button_url'        => get_theme_mod( 'parallax_button_url' ),
		'parallax_text_button'       => get_theme_mod( 'parallax_text_button' ),
		'parallax_text_after_button' => get_theme_mod( 'parallax_text_after_button' ),
		'parallax_bg_image_1'        => get_theme_mod( 'parallax_bg_image_1' ),
		'parallax_bg_image_2'        => get_theme_mod( 'parallax_bg_image_2' ),
	];
	set_query_var( 'template_args', $template_args );
	get_template_part( 'template-parts/home/promo', $slider_layout );
}
else {
	get_template_part( 'template-parts/home/promo', $slider_layout );
}