<?php
if ( ! Helper::is_woocommerce_active() ) {
	return;
}

$args               = get_query_var( 'template_args' );
$slides_data        = $args['slides'];
$menu_enabled       = $args['menu_enabled'];
$slider_two_enabled = $args['slider_two_enabled'];
$h1_on              = $args['h1_on'] ?? false;
$color_bg           = $args['color_bg'];
$without_gradient   = $args['without_gradient'];
$is_fullwidth       = $args['is_fullwidth'];

$style_bg = '';
if ( $color_bg ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$btn_flare = '';
if ( get_theme_mod( 'banner_button_type' ) == 'animation' ) {
	$btn_flare = 'btn-flare ';
}

$class_gradient = 'image-overlay_gradient';
if ( $without_gradient ) {
	$class_gradient = '';
}


if ( $menu_enabled || $slider_two_enabled ) {
	$is_fullwidth = false;
}
if ( $is_fullwidth ) {
	$class_goods = 'goods-main_long';
}
else {
	$class_goods = '';
}
?>
<div class="goods-main <?php echo $class_goods; ?>" id="goods-main" <?php echo $style_bg; ?>>
	<?php if ( ! $is_fullwidth ) { ?>
    <div class="container">
		<?php } ?>
        <div class="goods-main__row">
			<?php if ( $menu_enabled ) { ?>
                <div class="goods-main__col goods-main__col_menu">
					<?php get_template_part( 'template-parts/header/navigation', 'vertical', [ 'button_type' => 'div' ] ); ?>
                </div>
			<?php } ?>

            <div class="goods-main__col goods-main__col_big">
				<?php if ( isset( $slides_data['one'] ) && $slides_data['one'] ) { ?>
                    <div class="slider-wrapper">
                        <div class="goods-main__slider" <?php echo $args['data_autoplay_speed']; ?>>
							<?php foreach ( $slides_data['one'] as $key => $slide ) {
								$align_class = '';

								$text_h_align = $slide['woo_text_h_align'] ?? 'left';
								if ( $text_h_align !== 'left' ) {
									$align_class .= ' _h-' . $text_h_align;
								}

								$text_v_align = $slide['woo_text_v_align'] ?? 'bottom';
								if ( $text_v_align !== 'bottom' ) {
									$align_class .= ' _v-' . $text_v_align;
								}

								$is_video   = false;
								$video_id   = $slide['video'] ?? '';
								$youtube_id = isset( $slide['video_yt'] ) ? Helper::get_youtube_video_id( $slide['video_yt'] ) : '';
								if ( $video_id || $youtube_id ) {
									$is_video = true;
								}

								$video_attr      = [];
								$video_data_attr = [];
								if ( $video_id ) {
									if ( isset( $slide['video_autoplay'] ) && $slide['video_autoplay'] ) {
										$video_attr[] = 'autoplay';
										$video_attr[] = 'playsinline muted';
									}
									if ( isset( $slide['video_loop'] ) && $slide['video_loop'] ) {
										$video_attr[]      = 'loop';
										$video_data_attr[] = 'data-loop="true"';
									}
									if ( isset( $slide['video_control'] ) && $slide['video_control'] ) {
										$video_attr[]      = 'controls';
										$video_data_attr[] = 'data-controls="true"';
									}
								}

								if ( $is_video ) {
									$video_image_style = isset( $slide['image_url'] ) ? ' style="background-image: url(' . $slide['image_url'] . ');"' : '';
								}

								$button2 = [];
								if ( isset( $slide['button_label2'] ) && $slide['button_label2'] && $slide['button_url2'] && $slide['button_url2'] ) {
									$button2 = [
										'text' => $slide['button_label2'],
										'url'  => $slide['button_url2']
									];
								}

								$class_item_bonus = 'item-bonus';
								if ( ! $button2 ) {
									$class_item_bonus = 'item-bonus-one';
								}
								?>
                                <div class="goods-main__slide">
                                    <div class="goods-main-item <?php echo $class_item_bonus; ?><?php echo $align_class; ?>">
										<?php if ( $video_id ) { ?>
                                            <div class="_video-html <?php echo $class_gradient; ?>" data-src="<?php echo wp_get_attachment_url( $video_id ); ?>" <?php echo implode( ' ', $video_data_attr ); ?><?php echo $video_image_style; ?>>
												<?php if ( in_array( 'autoplay', $video_attr ) ) { ?>
                                                    <video width="100%" height="100%" <?php echo implode( ' ', $video_attr ); ?>>
                                                        <source src="<?php echo wp_get_attachment_url( $video_id ); ?>" type="video/mp4">
                                                    </video>
												<?php } else { ?>
                                                    <div class="btn-play">
                                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 448 512">
                                                            <path d="M424.4 214.7L72.4 6.6C43.8-10.3 0 6.1 0 47.9V464c0 37.5 40.7 60.1 72.4 41.3l352-208c31.4-18.5 31.5-64.1 0-82.6z" fill="white"></path>
                                                        </svg>
                                                    </div>
												<?php } ?>
                                            </div>
										<?php } elseif ( $youtube_id ) { ?>
                                            <div class="_video-iframe <?php echo $class_gradient; ?>" data-src="<?php echo $youtube_id; ?>"<?php echo $video_image_style; ?>>
                                                <div class="btn-play">
                                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 448 512">
                                                        <path d="M424.4 214.7L72.4 6.6C43.8-10.3 0 6.1 0 47.9V464c0 37.5 40.7 60.1 72.4 41.3l352-208c31.4-18.5 31.5-64.1 0-82.6z" fill="white"></path>
                                                    </svg>
                                                </div>
                                            </div>
										<?php } else { ?>
                                            <div class="goods-main-item__image image-overlay <?php echo $class_gradient; ?>">
												<?php echo $slide['image_html']; ?>
                                            </div>
										<?php } ?>

										<?php if ( $slide['title'] || $slide['text'] || $slide['link'] ) { ?>
                                            <div class="goods-main-item__body">
												<?php if ( $slide['category_html'] ) { ?>
                                                    <div class="goods-main-item__category"><?php echo $slide['category_html']; ?></div>
												<?php } ?>
												<?php if ( $slide['title'] ) { ?>
													<?php if ( $h1_on && $key == 0 ) { ?>
                                                        <h1 class="goods-main-item__title title title_white"><?php echo $slide['title']; ?></h1>
													<?php } else { ?>
                                                        <div class="goods-main-item__title title title_white"><?php echo $slide['title']; ?></div>
													<?php } ?>
												<?php } ?>
												<?php if ( $slide['text'] ) { ?>
                                                    <div class="goods-main-item__desc"><?php echo $slide['text']; ?></div>
												<?php } ?>
	                                            <?php if ( $slide['price'] ) { ?>
                                                    <div class="prices">
                                                        <span class="price-current"><?php echo $slide['price']; ?></span>
			                                            <?php if ( $slide['price_old'] ) { ?>
                                                            <span class="price-old"><?php echo $slide['price_old']; ?></span>
			                                            <?php } ?>
                                                    </div>
	                                            <?php } ?>
	                                            <?php if ( $slide['button_label'] && $slide['link'] && ! $button2 && ! $is_video ) { ?>
                                                    <button class="btn btn-main <?php echo $btn_flare; ?>"><span><?php echo $slide['button_label']; ?></span></button>
	                                            <?php } ?>
	                                            <?php if ( $slide['button_label'] && $slide['link'] && $button2 ) { ?>
		                                            <?php
		                                            $custom_class  = '';
		                                            $custom_class2 = '';

		                                            if ( strpos( $slide['link'], '#wescle-modal' ) !== false ) {
			                                            $custom_class = '_popup-link ';
		                                            }

		                                            if ( '#modal-call' == $slide['link'] ) {
			                                            $custom_class = '_popup-link ';
		                                            }

		                                            if ( strpos( $button2['url'], '#wescle-modal' ) !== false ) {
			                                            $custom_class2 = '_popup-link ';
		                                            }

		                                            if ( '#modal-call' == $button2['url'] ) {
			                                            $custom_class2 = '_popup-link ';
		                                            }
		                                            ?>
                                                    <div class="item-promo__btns">
                                                        <a href="<?php echo $slide['link']; ?>" class="btn btn-main <?php echo $custom_class; ?><?php echo $btn_flare; ?>"><span><?php echo $slide['button_label']; ?></span></a>
                                                        <a href="<?php echo $button2['url']; ?>" class="btn btn-main <?php echo $custom_class2; ?><?php echo $btn_flare; ?>"><span><?php echo $button2['text']; ?></span></a>
                                                    </div>
	                                            <?php } ?>
                                            </div>
										<?php } ?>
	                                    <?php if ( $slide['link'] && ! $button2 && ! $is_video ) { ?>
		                                    <?php
		                                    $custom_class = '';

		                                    if ( strpos( $slide['link'], '#wescle-modal' ) !== false ) {
			                                    $custom_class = '_popup-link';
		                                    }
		                                    if ( $slide['link'] == '#modal-call' ) {
			                                    $custom_class = '_popup-link';
		                                    }
		                                    ?>
                                            <a class="goods-main-item__link <?php echo $custom_class; ?>" href="<?php echo $slide['link']; ?>"></a>
										<?php } ?>
                                    </div>
                                </div>
							<?php } ?>
                        </div>
						<?php if ( 'true' === $args['data_arrows'] ) { ?>
                            <div class="slider-buttons">
                                <button class="slider-buttons__item slider-buttons__item_prev" type="button">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(180deg); -webkit-transform: rotate(180deg); transform: rotate(180deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                                        <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                                    </svg>
                                </button>
                                <button class="slider-buttons__item slider-buttons__item_next" type="button">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                                        <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                                    </svg>
                                </button>
                            </div>
						<?php } ?>
                    </div>
				<?php } ?>
            </div>
			<?php if ( isset( $slides_data['two'] ) && $slides_data['two'] ) { ?>
                <div class="goods-main__col goods-main__col_small">
                    <div class="goods-main__inner-wrapper">
                        <div class="goods-main__inner-buttons slider-buttons">
                            <button class="slider-buttons__item slider-buttons__item_prev" type="button">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(180deg); -webkit-transform: rotate(180deg); transform: rotate(180deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                                    <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                                </svg>
                            </button>
                            <button class="slider-buttons__item slider-buttons__item_next" type="button">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                                    <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                                </svg>
                            </button>
                        </div>
                        <div class="goods-main__inner-slider" <?php echo $args['data_autoplay_speed']; ?>>
		                    <?php
		                    foreach ( $slides_data['two'] as $slide ) { ?>
			                    <?php
			                    $align_class = '';

			                    $text_h_align = $slide['woo_text_h_align'] ?? 'left';
			                    if ( $text_h_align !== 'left' ) {
				                    $align_class .= ' _h-' . $text_h_align;
			                    }

			                    $text_v_align = $slide['woo_text_v_align'] ?? 'bottom';
			                    if ( $text_v_align !== 'bottom' ) {
				                    $align_class .= ' _v-' . $text_v_align;
			                    }

			                    $custom_class = '';
			                    if ( $slide['link'] ) {
				                    if ( strpos( $slide['link'], '#wescle-modal' ) !== false ) {
					                    $custom_class = '_popup-link';
				                    }
				                    if ( $slide['link'] == '#modal-call' ) {
					                    $custom_class = '_popup-link';
				                    }
			                    }
			                    ?>
                                <div class="goods-main__inner-slide">
                                    <a class="goods-main-inner-item<?php echo $align_class; ?> <?php echo $custom_class; ?>" href="<?php echo $slide['link']; ?>">
                                        <div class="goods-main-inner-item__image image-overlay <?php echo $class_gradient; ?>">
						                    <?php echo $slide['image_html']; ?>
                                        </div>
                                        <div class="goods-main-inner-item__body">
						                    <?php if ( $slide['title'] ) { ?>
                                                <div class="goods-main-inner-item__title title title_white"><?php echo $slide['title']; ?></div>
						                    <?php } ?>
						                    <?php if ( $slide['price'] ) { ?>
                                                <div class="prices">
                                                    <span class="price-current"><?php echo $slide['price']; ?></span>
								                    <?php if ( $slide['price_old'] ) { ?>
                                                        <span class="price-old"><?php echo $slide['price_old']; ?></span>
								                    <?php } ?>
                                                </div>
						                    <?php } ?>
                                        </div>
                                    </a>
                                </div>
			                    <?php
		                    }
							?>
                        </div>
                    </div>
                </div>
			<?php } ?>
        </div>
		<?php if ( ! $is_fullwidth ) { ?>
    </div> <!-- .container -->
<?php } ?>
</div>