<?php
$args = get_query_var( 'template_args' );
if ( ! $args ) {
	return;
}

$label_text = $args['parallax_label_text'];
$title      = $args['parallax_title_1'];
$title_type = $args['parallax_title_type'];
$text_items = $args['parallax_text_items'];

$button_label         = $args['parallax_button_label'];
$button_url           = $args['parallax_button_url'];
$button_text_animated = $args['parallax_text_button'];
$text_after_button    = $args['parallax_text_after_button'];

$bg_image_1     = $args['parallax_bg_image_1'];
$parallax_image = $args['parallax_bg_image_2'];

$block_attributes = $args['block_attributes'] ?? [];

$color_bg = $args['color_bg'];
$style_bg = '';
if ( $color_bg ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$btn_flare = $args['btn_flare'] ?? '';
$btn_flare = '';

$section_class = '';
if ( isset( $block_attributes['blockPosition'] ) ) {
	$section_position = $block_attributes['blockPosition'];
}
else {
	$section_position = get_theme_mod( 'parallax_position_content', 'default' );
}
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="promo-parallax<?php echo $section_class; ?>" <?php echo $style_bg; ?> id="promo-parallax" data-scene="">
	<?php
	if ( ! Helper::is_landing_page() ) {
		echo wescle_home_block_bg_image( 'parallax_image_bg' );
	}
	else {
		wescle_blocks_bg_image( $block_attributes );
	}
	?>
    <div class="container">
        <div class="promo-parallax__grid">
            <div class="promo-parallax__col">
                <div class="promo-parallax__about">
					<?php if ( $label_text ) { ?>
                        <span class="promo-parallax__label"><?php echo $label_text; ?></span>
					<?php } ?>
					<?php
					if ( $title ) {
						printf( '<%1$s class="promo-parallax__title title title_divider">' . $title . '</%1$s>', $title_type );
					}
					?>
					<?php if ( $text_items ) { ?>
                        <ul class="promo-parallax-advantages">
							<?php foreach ( $text_items as $item ) { ?>
                                <li class="promo-parallax-advantages__item">
									<?php if ( $item['image'] ) { ?>
                                        <div class="promo-parallax-advantages__item-img">
											<?php echo wp_get_attachment_image( $item['image'], 'medium' ); ?>
                                        </div>
									<?php } ?>
                                    <span><?php echo $item['text']; ?></span>
                                </li>
							<?php } ?>
                        </ul>
					<?php } ?>
                    <div class="promo-parallax__btn">
						<?php if ( $button_label && $button_url ) { ?>
							<?php
							$custom_class = '';

							if ( strpos( $button_url, '#wescle-modal' ) !== false || $button_url == '#modal-call' ) {
								$custom_class = '_popup-link';
							}
							?>
                            <a class="btn btn-main <?php echo $btn_flare; ?><?php echo $custom_class; ?>" href="<?php echo $button_url; ?>">
                                <span><?php echo $button_label; ?></span>
								<?php if ( $button_text_animated ) { ?>
                                    <span class="_when _animated"><?php echo do_shortcode( $button_text_animated ); ?></span>
								<?php } ?>
                            </a>
						<?php } ?>
                    </div>
					<?php if ( $text_after_button ) { ?>
                        <div class="promo-parallax__description"><?php echo str_replace( [ '</p><p>', '<p>', '</p>' ], [ '<br><br>', '', '' ], $text_after_button ); ?></div>
					<?php } ?>
                </div>
            </div>
            <div class="promo-parallax__col promo-parallax__col_dec">
                <div class="promo-parallax-decoration" data-da=".promo-parallax__about,768,2">
                    <div class="promo-parallax-decoration__main">
				        <?php if ( $bg_image_1 ) { ?>
					        <?php echo wp_get_attachment_image( $bg_image_1, 'medium_large' ); ?>
				        <?php } ?>
                    </div>
			        <?php if ( $parallax_image ) { ?>
				        <?php echo wp_get_attachment_image( $parallax_image, 'medium_large', false, [ 'class' => '_move', 'data-depth' => '0.3' ] ); ?>
			        <?php } ?>
                </div>
            </div>
        </div>
    </div>
</div>