<?php
$args                 = get_query_var( 'template_args' );
$left_posts           = $args['left_posts_in_slider'];
$left_post_card_order = $args['left_post_card_order'];
$left_post_card_meta  = $args['left_post_card_meta'];

$right_posts           = $args['right_posts_in_slider'];
$right_post_card_order = $args['right_post_card_order'];
$right_post_card_meta  = $args['right_post_card_meta'];

$content_box      = $args['content_box'];
$color_bg         = $args['color_bg'];
$without_gradient = $args['without_gradient'];

if ( $left_posts ) {
	shuffle( $left_posts );
}

$style_bg = '';
if ( $color_bg ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$class_gradient = 'image-overlay_gradient';
if ( $without_gradient ) {
	$class_gradient = '';
}
?>
<div class="promo promo_v4" <?php echo $style_bg; ?>>
    <div class="container">
        <div class="row promo__row">
            <div class="col promo__col promo__col_big">
				<?php
				foreach ( $left_posts as $key => $post ) {
					setup_postdata( $post );
					?>
                    <div class="promo__item item-promo item-promo_big post">
                        <div class="item-promo__image image-overlay <?php echo $class_gradient; ?> post__image">
							<?php
							$thumb_size = 'medium_large';
							if ( $content_box == 'default' ) {
								$thumb_size = THEME_SLUG . 'large';
							}

							if ( $img_id = get_post_meta( $post->ID, 'thumbnail_archive', 1 ) ) {
								$img = wp_get_attachment_image( $img_id, $thumb_size );
							}
							else {
								$img = get_the_post_thumbnail( $post, $thumb_size );
							}

							if ( $key == 0 ) {
								$img = str_replace( 'loading="lazy"', '', $img );
							}
							echo $img;
							?>
                        </div>
                        <div class="item-promo__body post__body">
							<?php
							block_promo_link();

							foreach ( $left_post_card_order as $block ) {

								if ( $block == 'category' ) {
									post_card_category( 'item-promo__category', 1, false );
								}

								if ( $block == 'title' ) {
									block_promo_title();
								}

								if ( $block == 'meta' ) {
									post_card_meta( $left_post_card_meta, true, false, false );
								}

							}
							?>
                        </div>
                    </div>
					<?php
					break;
				}
				?>
            </div>
            <div class="col promo__col">
                <div class="row promo__subrow">
					<?php
					$count_loop = 0;
					foreach ( $right_posts as $post ) {
						setup_postdata( $post );
						$count_loop ++;
						?>
                        <div class="col">
                            <div class="promo__item item-promo item-promo_long post">

                                <div class="item-promo__image image-overlay <?php echo $class_gradient; ?> post__image">
                                    <picture>
										<?php
										if ( $img_id = get_post_meta( $post->ID, 'thumbnail_archive', 1 ) ) {
											echo wp_get_attachment_image( $img_id, 'medium_large' );
										}
										else {
											the_post_thumbnail( 'medium_large' );
										}
										?>
                                    </picture>
                                </div>
                                <div class="item-promo__body post__body">
									<?php
									block_promo_link();

									foreach ( $right_post_card_order as $block ) {

										if ( $block == 'category' ) {
											post_card_category( 'item-promo__category', 1, false );
										}

										if ( $block == 'title' ) {
											block_promo_title();
										}

										if ( $block == 'meta' ) {
											post_card_meta( $right_post_card_meta, true, false, false );
										}

									}
									?>
                                </div>

                            </div>
                        </div>
						<?php
						if ( $count_loop == 2 ) {
							break;
						}
					}
					wp_reset_postdata();
					?>
                </div>
            </div>
        </div>
    </div>
</div>
