<?php
$args            = get_query_var( 'template_args' );
$posts_slider    = $args['posts_in_slider'];
$post_card_order = $args['post_card_order'];

$post_card_meta   = $args['post_card_meta'];
$content_box      = $args['content_box'];
$is_fullwidth     = $args['is_fullwidth'];
$color_bg         = $args['color_bg'];
$without_gradient = $args['without_gradient'];

$thumb_size = THEME_SLUG . '_single_thumbnail';
if ( $content_box == 'default' ) {
	$thumb_size = THEME_SLUG . '_promo_banner';
}

if ( ! $posts_slider ) {
	return;
}

$style_bg = '';
if ( $color_bg ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$class_gradient = 'image-overlay_gradient';
if ( $without_gradient ) {
	$class_gradient = '';
}

if ( $is_fullwidth ) {
	$class_promo = 'promo_v6';
}
else {
	$class_promo = 'promo_v2';
}
?>
<div class="promo <?php echo $class_promo; ?>" <?php echo $style_bg; ?>>
	<?php if ( ! $is_fullwidth ) { ?>
    <div class="container">
		<?php } ?>
        <div class="slider-wrapper _hide-arrows-mobile">
            <div class="promo__slider" <?php echo $args['data_autoplay_speed']; ?>>
				<?php
				foreach ( $posts_slider as $key => $post ) {
					setup_postdata( $post );
					?>
                    <div class="promo__slide">
                        <div class="promo__item item-promo post">
                            <div class="item-promo__image image-overlay <?php echo $class_gradient; ?> post__image">
								<?php
								if ( $img_id = get_post_meta( $post->ID, 'thumbnail_archive', 1 ) ) {
									$img = wp_get_attachment_image( $img_id, $thumb_size );
								}
								else {
									$img = get_the_post_thumbnail( $post, $thumb_size );
								}

								if ( $key == 0 ) {
									$img = str_replace( 'loading="lazy"', '', $img );
								}
								echo $img;
								?>
                            </div>
                            <div class="item-promo__body post__body">
								<?php
								block_promo_link();

								foreach ( $post_card_order as $block ) {

									if ( $block == 'category' ) {
										post_card_category( 'item-promo__category', 1, false );
									}

									if ( $block == 'title' ) {
										block_promo_title();
									}

									if ( $block == 'meta' ) {
										post_card_meta( $post_card_meta, true, false, false );
									}

								}
								?>
                            </div>
                        </div>
                    </div>
					<?php
				}
				wp_reset_postdata();
				?>
            </div>
			<?php if ( 'true' === $args['data_arrows'] ) { ?>
                <div class="slider-buttons">
                    <button class="slider-buttons__item slider-buttons__item_prev" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(180deg); -webkit-transform: rotate(180deg); transform: rotate(180deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                            <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                        </svg>
                    </button>
                    <button class="slider-buttons__item slider-buttons__item_next" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                            <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                        </svg>
                    </button>
                </div>
			<?php } ?>
        </div>
		<?php if ( ! $is_fullwidth ) { ?>
    </div> <!-- .container -->
<?php } ?>
</div>