<?php
$args             = get_query_var( 'template_args' );
$slides           = $args['slides'];
$content_box      = $args['content_box'];
$h1_on            = $args['h1_on'];
$color_bg         = $args['color_bg'];
$is_fullwidth     = $args['is_fullwidth'];
$without_gradient = $args['without_gradient'] ?? '';
$slider_effect    = $args['slider_effect'] ?? 'slide';

$thumb_size = 'full';

$style_bg = '';
if ( $color_bg ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$btn_flare = '';
if ( get_theme_mod( 'banner_button_type' ) == 'animation' ) {
	$btn_flare = 'btn-flare ';
}

$custom_css = '';
foreach ( $slides as $key => $slide ) {
	if ( isset( $slide['text_color'] ) && $slide['text_color'] && $slide['text_color'] != '#ffffff' ) {
		$custom_css .= '.promo__slide-' . $key . ' .item-bonus .post__info, .promo__slide-' . $key . ' .item-promo__title .title, .promo__slide-' . $key . ' .item-promo__title:hover .title{color:' . $slide['text_color'] . '}';
	}
}
if ( $custom_css ) {
	echo '<style>' . $custom_css . '</style>';
}

if ( $is_fullwidth ) {
	$class_promo = 'promo_v6';
}
else {
	$class_promo = 'promo_banner';
}
foreach ( $slides as $key => $slide ) {
	$video_id = $slide['video'] ?? '';
	$video_yt = $slide['video_yt'] ?? '';
	if ( $video_id || $video_yt ) {
		$class_promo .= ' _with-video';
		break;
	}
}
?>
<div class="promo <?php echo $class_promo; ?>" <?php echo $style_bg; ?>>
	<?php if ( ! $is_fullwidth ) { ?>
    <div class="container">
		<?php } ?>
        <div class="slider-wrapper _hide-arrows-mobile">
            <div class="promo__slider" <?php echo $args['data_autoplay_speed']; ?> <?php echo $args['slider_effect']; ?>>
				<?php
				foreach ( $slides as $key => $slide ) {
					$slide['text_width'] = $slide['text_width'] ? $slide['text_width'] : '100';

					$is_video   = false;
					$video_id   = $slide['video'] ?? '';
					$youtube_id = isset( $slide['video_yt'] ) ? Helper::get_youtube_video_id( $slide['video_yt'] ) : '';
					if ( $video_id || $youtube_id ) {
						$is_video = true;
					}

					$video_attr      = [];
					$video_data_attr = [];
					if ( $video_id ) {
						if ( isset( $slide['video_autoplay'] ) && $slide['video_autoplay'] ) {
							$video_attr[] = 'autoplay';
							$video_attr[] = 'playsinline muted';
						}
						if ( isset( $slide['video_loop'] ) && $slide['video_loop'] ) {
							$video_attr[]      = 'loop';
							$video_data_attr[] = 'data-loop="true"';
						}
						if ( isset( $slide['video_control'] ) && $slide['video_control'] ) {
							$video_attr[]      = 'controls';
							$video_data_attr[] = 'data-controls="true"';
						}
					}

					if ( $is_video ) {
						$video_image_style = $slide['image'] ? ' style="background-image: url(' . wp_get_attachment_url( $slide['image'] ) . ');"' : '';
					}
					else {
						$image_html = wp_get_attachment_image( $slide['image'], $thumb_size, false, [ 'alt' => esc_attr( $slide['title'] ) ] );
						$image_html = wescle_add_srcset( $image_html, $slide['image'], [ $thumb_size, 'medium_large', 'large' ] );

						if ( $key == 0 ) {
							$image_html = str_replace( 'loading="lazy"', '', $image_html );
						}
					}

					$class_overlay = 'image-overlay_gradient';
					if ( ( isset( $slide['overlay_off'] ) && $slide['overlay_off'] ) || $without_gradient ) {
						$class_overlay = '';
					}

					$align_class = '';

					$text_h_align = $slide['text_h_align'] ?? 'left';
					if ( $text_h_align !== 'left' ) {
						$align_class .= ' _h-' . $text_h_align;
					}

					$text_v_align = $slide['text_v_align'] ?? 'bottom';
					if ( $text_v_align !== 'bottom' ) {
						$align_class .= ' _v-' . $text_v_align;
					}

					$button2 = [];
					if ( isset( $slide['button_text2'] ) && $slide['button_text2'] && $slide['button_link2'] && $slide['button_link2'] ) {
						$button2 = [
							'text' => $slide['button_text2'],
							'url'  => $slide['button_link2']
						];
					}

					$class_item_bonus = 'item-bonus ';
					if ( ! $button2 ) {
						$class_item_bonus .= 'item-bonus-one ';
					}
					?>
                    <div class="promo__slide promo__slide-<?php echo $key; ?>">
                        <div class="promo__item item-promo <?php echo $class_item_bonus; ?>post<?php echo $align_class; ?>">
							<?php if ( $video_id ) { ?>
                                <div class="_video-html <?php echo $class_overlay; ?>" data-src="<?php echo wp_get_attachment_url( $video_id ); ?>" <?php echo implode( ' ', $video_data_attr ); ?><?php echo $video_image_style; ?>>
									<?php if ( in_array( 'autoplay', $video_attr ) ) { ?>
                                        <video width="100%" height="100%" <?php echo implode( ' ', $video_attr ); ?>>
                                            <source src="<?php echo wp_get_attachment_url( $video_id ); ?>" type="video/mp4">
                                        </video>
									<?php } else { ?>
                                        <div class="btn-play">
                                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 448 512">
                                                <path d="M424.4 214.7L72.4 6.6C43.8-10.3 0 6.1 0 47.9V464c0 37.5 40.7 60.1 72.4 41.3l352-208c31.4-18.5 31.5-64.1 0-82.6z" fill="white"></path>
                                            </svg>
                                        </div>
									<?php } ?>
                                </div>
							<?php } elseif ( $youtube_id ) { ?>
                                <div class="_video-iframe <?php echo $class_overlay; ?>" data-src="<?php echo $youtube_id; ?>"<?php echo $video_image_style; ?>>
                                    <div class="btn-play">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 448 512">
                                            <path d="M424.4 214.7L72.4 6.6C43.8-10.3 0 6.1 0 47.9V464c0 37.5 40.7 60.1 72.4 41.3l352-208c31.4-18.5 31.5-64.1 0-82.6z" fill="white"></path>
                                        </svg>
                                    </div>
                                </div>
							<?php } else { ?>
                                <div class="item-promo__image image-overlay <?php echo $class_overlay; ?> post__image">
									<?php echo $image_html; ?>
                                </div>
							<?php } ?>
							<?php if ( $slide['title'] || $slide['text'] ) { ?>
                                <div class="item-promo__body post__body post__width-<?php echo $slide['text_width']; ?>">
                                    <div class="item-promo__title post__title">
										<?php if ( $h1_on && $key == 0 ) { ?>
                                            <h1 class="title title_white"><?php echo $slide['title']; ?></h1>
										<?php } else { ?>
                                            <div class="title title_white"><?php echo $slide['title']; ?></div>
										<?php } ?>
                                    </div>
									<?php if ( $slide['text'] ) { ?>
                                        <div class="item-promo__text post__info services__text"><?php echo nl2br( $slide['text'] ); ?></div>
									<?php } ?>
									<?php if ( $slide['button_text'] && ! $button2 && ! $is_video ) { ?>
                                        <div>
                                            <button class="item-promo__btn btn btn-main <?php echo $btn_flare; ?>"><?php echo $slide['button_text']; ?></button>
                                        </div>
									<?php } elseif ( $slide['button_text'] && $button2 ) { ?>
										<?php
										$custom_class  = '';
										$custom_class2 = '';

										if ( strpos( $slide['button_link'], '#wescle-modal' ) !== false ) {
											$custom_class = '_popup-link ';
										}

										if ( '#modal-call' == $slide['button_link'] ) {
											$custom_class = '_popup-link ';
										}

										if ( strpos( $button2['url'], '#wescle-modal' ) !== false ) {
											$custom_class2 = '_popup-link ';
										}

										if ( '#modal-call' == $button2['url'] ) {
											$custom_class2 = '_popup-link ';
										}
										?>
                                        <div class="item-promo__btns">
                                            <a href="<?php echo $slide['button_link']; ?>" class="item-promo__btn btn btn-main <?php echo $custom_class; ?><?php echo $btn_flare; ?>"><?php echo $slide['button_text']; ?></a>
                                            <a href="<?php echo $button2['url']; ?>" class="item-promo__btn btn btn-main <?php echo $custom_class2; ?><?php echo $btn_flare; ?>"><?php echo $button2['text']; ?></a>
                                        </div>
									<?php } ?>
                                </div>
							<?php } ?>
	                        <?php if ( $slide['button_link'] && ! $button2 && ! $is_video ) {
		                        $custom_class = '';

		                        if ( strpos( $slide['button_link'], '#wescle-modal' ) !== false ) {
			                        $custom_class = '_popup-link';
		                        }

		                        if ( '#modal-call' == $slide['button_link'] ) {
			                        $custom_class = '_popup-link';
		                        }
		                        ?>
                                <a class="item-promo__link <?php echo $custom_class; ?>" href="<?php echo $slide['button_link']; ?>"></a>
	                        <?php } ?>
                        </div>
                    </div>
					<?php
				}
				?>
            </div>
			<?php if ( 'true' === $args['data_arrows'] ) { ?>
                <div class="slider-buttons">
                    <button class="slider-buttons__item slider-buttons__item_prev" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(180deg); -webkit-transform: rotate(180deg); transform: rotate(180deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                            <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                        </svg>
                    </button>
                    <button class="slider-buttons__item slider-buttons__item_next" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                            <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                        </svg>
                    </button>
                </div>
			<?php } ?>
	        <?php get_template_part( 'template-parts/home/promo-banner-form' ); ?>
        </div>
	    <?php if ( ! $is_fullwidth ) { ?>
    </div> <!-- .container -->
<?php } ?>
</div>