<?php
if ( ! get_theme_mod( 'module_catalog_enabled' ) ) {
	return;
}

$promo_form = get_theme_mod( 'slider_banner_catalog_form' );
if ( ! $promo_form ) {
	return;
}

$options_cat     = [];
$data_child_cat  = [];
$is_child_cat    = false;
$child_cat_label = __( 'Подкатегории', 'wescle' );

$args_terms = [
	'taxonomy' => 'catalogcat_wescle',
	'parent'   => 0,
];
$terms      = get_terms( $args_terms );

foreach ( $terms as $term ) {
	$link          = get_term_link( $term );
	$options_cat[] = '<option value="' . $term->term_id . '" data-link="' . $link . '">' . $term->name . '</option>';

	$data_child_cat[ $term->term_id ][] = [
		'',
		'',
		$child_cat_label
	];

	$args_terms['parent'] = $term->term_id;
	$child_terms          = get_terms( $args_terms );
	if ( $child_terms ) {
		$is_child_cat = true;
		foreach ( $child_terms as $child_term ) {
			$data_child_cat[ $term->term_id ][] = [
				$child_term->term_id,
				get_term_link( $child_term ),
				$child_term->name
			];
		}
	}
}

$filter_choices  = Helper::get_catalog_filter_choices();
$filters_options = [];
$filters         = get_theme_mod( 'slider_banner_catalog_form_filters' );
if ( $filters ) {
	$filters = wp_list_pluck( $filters, 'filter_taxonomy' );
	foreach ( $filters as $filter_taxonomy ) {
		if ( taxonomy_exists( $filter_taxonomy ) ) {
			$terms = get_terms( [ 'taxonomy' => $filter_taxonomy ] );
			if ( $terms ) {
				$filters_options[ $filter_taxonomy ] = [
					'<option value="">' . $filter_choices[ $filter_taxonomy ] . '</option>'
				];
				foreach ( $terms as $term ) {
					$filters_options[ $filter_taxonomy ][] = '<option value="' . $term->slug . '">' . $term->name . '</option>';
				}
			}
		}
	}
}

$form_action = '#';
$pages       = get_posts( [
	'post_type'        => 'page',
	'posts_per_page'   => 1,
	'meta_key'         => '_wp_page_template',
	'meta_value'       => 'templates/template-catalog_wescle.php',
	'suppress_filters' => false
] );
if ( $pages ) {
	$form_action = get_permalink( current( $pages )->ID );
}
?>
<div class="wescle-promo-form">
    <div class="container">
        <form class="wescle-promo-form__container" action="<?php echo $form_action; ?>" method="post" data-child_cats="<?php echo htmlspecialchars( json_encode( $data_child_cat ), ENT_QUOTES, 'UTF-8' ); ?>">
            <select id="catalog_cat">
                <option value=""><?php _e( 'Категории', 'wescle' ); ?></option>
				<?php echo implode( '', $options_cat ); ?>
            </select>
			<?php if ( $data_child_cat ) { ?>
                <select id="catalog_subcat">
                    <option value=""><?php echo $child_cat_label; ?></option>
                </select>
			<?php } ?>
			<?php foreach ( $filters_options as $filter_tax => $options ) { ?>
                <select id="<?php echo str_replace( 'filter_', 'filters_', $filter_tax ); ?>" class="select-filter">
					<?php echo implode( '', $options ); ?>
                </select>
			<?php } ?>
            <button type="submit" class="btn btn-main btn-main_blue"><?php _e( 'Поиск', 'wescle' ); ?></button>
        </form>
    </div>
</div>