<?php
$args = get_query_var( 'template_args' );
if ( ! $args ) {
	return;
}

$label_text       = $args['animated_label_text'];
$label_href       = $args['animated_label_href'];
$title_1          = $args['animated_title_1'];
$title_type       = $args['animated_title_type'] ? $args['animated_title_type'] : 'div';
$title_text_items = $args['animated_title_text_items'];
$title_2          = str_replace( '<strong>', '<strong class="colored-text">', $args['animated_title_2'] );
$title_2          = str_replace( 'strong', 'span', $title_2 );
$title_3          = $args['animated_title_3'];
$buttons          = $args['animated_buttons'];
$advantages       = $args['animated_advantages'];
$bg_image_1       = $args['animated_bg_image_1'];
$play_label       = $args['animated_play_label'];
$video_id         = '';
$video_href       = $args['animated_video_href'];
if ( $video_href ) {
	$video_id = Helper::get_youtube_video_id( $video_href );
}
$block_attributes = $args['block_attributes'] ?? [];

$text_items_classes = [
	'one',
	'two',
	'three',
];

$color_bg = $args['color_bg'];
$style_bg = '';
if ( $color_bg ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$btn_flare = $args['btn_flare'] ?? '';

$section_class = '';
if ( isset( $block_attributes['blockPosition'] ) ) {
	$section_position = $block_attributes['blockPosition'];
}
else {
	$section_position = get_theme_mod( 'animated_position_content', 'default' );
}
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="animated-banner<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php
	if ( ! Helper::is_landing_page() ) {
		echo wescle_home_block_bg_image( 'animated_image_bg' );
	}
	else {
		wescle_blocks_bg_image( $block_attributes );
	}
	?>
    <div class="container">
        <div class="animated-banner__row">
            <div class="animated-banner__col">
                <div class="animated-banner__content">
	                <?php if ( $label_text ) { ?>
                        <a class="animated-banner__label" href="<?php echo $label_href; ?>"><?php echo $label_text; ?></a>
	                <?php } ?>
                    <<?php echo $title_type; ?> class="animated-banner__title title title_divider">
                        <div><?php echo $title_1; ?>
							<?php if ( $title_text_items ) { ?>
                                <div class="animated-text">
									<?php foreach ( $title_text_items as $key => $text ) { ?>
										<?php
										$style = '';
										if ( isset( $text['item_color'] ) && $text['item_color'] ) {
											$style = ' style="color:' . $text['item_color'] . '"';
										}
										?>
                                        <span class="<?php echo $text_items_classes[ $key ]; ?>"<?php echo $style; ?>><?php echo $text['item_text']; ?></span>
									<?php } ?>
                                </div>
							<?php } ?>
                        </div>
                        <div><?php echo $title_2; ?></div>
                    </<?php echo $title_type; ?>>
					<?php if ( $title_3 ) { ?>
                        <div class="animated-banner__subtitle _section-about"><?php echo $title_3; ?></div>
					<?php } ?>
					<?php if ( $buttons ) { ?>
                        <div class="animated-banner__actions">
							<?php foreach ( $buttons as $key => $item ) { ?>
								<?php if ( $item['button_text'] ) { ?>
									<?php $target = isset( $item['is_blank'] ) && $item['is_blank'] ? 'target="_blank"' : ''; ?>
                                    <div class="animated-banner__actions-col"><a class="btn btn-main <?php echo $btn_flare; ?>" href="<?php echo $item['button_url']; ?>" <?php echo $target; ?>><span><?php echo $item['button_text']; ?></span></a></div>
								<?php } ?>
							<?php } ?>
                        </div>
					<?php } ?>
					<?php if ( $advantages ) { ?>
                        <div class="animated-banner__advantages advantages">
                            <ul>
								<?php foreach ( $advantages as $key => $item ) { ?>
                                    <li>
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="22" height="22" viewbox="0 0 22 22">
                                            <g transform="translate(5.224 2.764)">
                                                <path d="M137.715,64.571a.829.829,0,0,0-1.172,0L126.6,74.49l-3.589-3.9a.829.829,0,0,0-1.22,1.123l4.173,4.532a.828.828,0,0,0,.592.267h.018a.83.83,0,0,0,.585-.242l10.558-10.53A.829.829,0,0,0,137.715,64.571Z" transform="translate(-121.568 -64.327)"></path>
                                            </g>
                                            <path d="M21.171,10.171a.829.829,0,0,0-.829.829A9.342,9.342,0,1,1,11,1.658.829.829,0,1,0,11,0,11,11,0,1,0,22,11,.829.829,0,0,0,21.171,10.171Z"></path>
                                        </svg>
                                        <span><?php echo $item['item_text']; ?></span>
                                    </li>
								<?php } ?>
                            </ul>
                        </div>
					<?php } ?>
                </div>
            </div>

            <div class="animated-banner__col">
                <div class="animated-banner__video">
					<?php if ( $bg_image_1 ) { ?>
                        <div class="animated-banner__video-img">
							<?php echo wp_get_attachment_image( $bg_image_1, 'medium_large' ); ?>
                        </div>
					<?php } ?>
					<?php if ( $video_id ) { ?>
                        <a class="btn-play _popup-link" href="#modal-video" data-video="<?php echo $video_id; ?>">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="76.749" height="76.749" viewbox="0 0 76.749 76.749">
                                <defs>
                                    <style>
                                      .play-a {
                                        stroke: rgba(0, 0, 0, 0);
                                        fill: url(#play-a);
                                      }
                                    </style>
                                    <radialgradient id="play-a" cx="0.564" cy="0.266" r="0.691" gradienttransform="matrix(0.986, 0.019, -0.019, 1, 0.014, -0.011)" gradientunits="objectBoundingBox">
                                        <stop offset="0" stop-color="#ffbf00"></stop>
                                        <stop offset="0.976" stop-color="#ff9300"></stop>
                                    </radialgradient>
                                </defs>
                                <path class="play-a" d="M41.249,3.375A37.874,37.874,0,1,0,79.124,41.249,37.918,37.918,0,0,0,41.249,3.375Zm-10.2,53.9V25.227L57.272,41.252Z" transform="translate(-2.875 -2.875)"></path>
                            </svg>
							<?php if ( $play_label ) { ?>
                                <span><?php echo $play_label; ?></span>
							<?php } ?>
                        </a>
					<?php } ?>
                </div>
            </div>
        </div>
    </div>
</div>