<?php
$block_enabled = get_theme_mod( 'home_programs_enabled', false );
if ( ! $block_enabled ) {
	return;
}

if ( is_front_page() ) {
	if ( ! get_theme_mod( 'home_programs_enabled_home', true ) ) {
		return;
	}
}

$title            = get_theme_mod( 'home_programs_title' );
$title_type       = get_theme_mod( 'home_programs_title_type', 'div' );
$text             = get_theme_mod( 'home_programs_text' );
$program_post_ids = get_theme_mod( 'home_programs_posts', [] );
if ( count( $program_post_ids ) == 1 && $program_post_ids[0] == '' ) {
	$program_post_ids = [];
}

$posts_per_page = 30;
$post__in       = [];
if ( $program_post_ids ) {
	$posts_per_page = count( $program_post_ids );
	$post__in       = $program_post_ids;
}
$program_posts = get_posts( [
	'post_type'        => 'program_wescle',
	'posts_per_page'   => $posts_per_page,
	'post__in'         => $post__in,
	'orderby'          => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
	'suppress_filters' => false
] );

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_programs_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_programs_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$icon1_title    = get_theme_mod( 'home_programs_icon1_title' );
$icon1_subtitle = get_theme_mod( 'home_programs_icon1_subtitle' );
$icon2_title    = get_theme_mod( 'home_programs_icon2_title' );
$icon2_subtitle = get_theme_mod( 'home_programs_icon2_subtitle' );
$icon3_title    = get_theme_mod( 'home_programs_icon3_title' );
$icon3_subtitle = get_theme_mod( 'home_programs_icon3_subtitle' );
$icon4_title    = get_theme_mod( 'home_programs_icon4_title' );
$icon4_subtitle = get_theme_mod( 'home_programs_icon4_subtitle' );

if ( is_page_template( 'templates/template-programs.php' ) ) {
	$style_bg    = '';
	$style_title = '';
	$title       = '';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_programs_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="schedule-block<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="schedule-block__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
		<?php if ( $text ) { ?>
            <div class="_section-about">
                <div class="_section-about__text">
					<?php echo $text; ?>
                </div>
            </div>
		<?php } ?>
        <div class="schedule-block-top">
			<?php if ( $icon1_title || $icon1_subtitle ) { ?>
                <div class="schedule-block-top__item">
                    <div class="schedule-block-top__item-img">
                        <svg xmlns="http://www.w3.org/2000/svg" width="96.715" height="109.65" viewbox="0 0 96.715 109.65">
                            <g transform="translate(-5.76 -2.25)">
                                <path d="M16.875,12.375h8.454V50.418H16.875Z" transform="translate(30.649 27.918)"></path>
                                <path d="M14.625,2.25H39.987V10.7H14.625Z" transform="translate(24.445 0)"></path>
                                <path d="M102.474,19.244l-6-5.959-9.51,9.51a46.241,46.241,0,1,0,4.986,6.974ZM51.751,91.1A38.043,38.043,0,1,1,89.794,53.06,38.043,38.043,0,0,1,51.751,91.1Z" transform="translate(0 12.595)"></path>
                            </g>
                        </svg>
                    </div>
					<?php if ( $icon1_title ) { ?>
                        <div class="schedule-block-top__item-title"><?php echo $icon1_title; ?></div>
					<?php } ?>
					<?php if ( $icon1_subtitle ) { ?>
                        <div class="schedule-block-top__item-about"><?php echo $icon1_subtitle; ?></div>
					<?php } ?>
                </div>
			<?php } ?>
			<?php if ( $icon2_title || $icon2_subtitle ) { ?>
                <div class="schedule-block-top__item">
                    <div class="schedule-block-top__item-img">
                        <svg xmlns="http://www.w3.org/2000/svg" width="109.65" height="109.65" viewbox="0 0 109.65 109.65">
                            <g transform="translate(-4.5 -4.5)">
                                <path d="M105.013,96.932H13.638A9.146,9.146,0,0,1,4.5,87.794V19.263a9.146,9.146,0,0,1,9.138-9.138h25.89a9.194,9.194,0,0,1,5.483,1.828L60.844,23.831h44.169a9.146,9.146,0,0,1,9.138,9.138V87.794A9.146,9.146,0,0,1,105.013,96.932ZM39.523,19.263H13.629l.008,68.531h91.375V32.969H57.8Z" transform="translate(0 17.219)"></path>
                                <path d="M107.263,27.344H60.048L41.773,13.638H6.75V4.5H41.777A9.194,9.194,0,0,1,47.26,6.328L63.1,18.206h44.165Z" transform="translate(6.888 0)"></path>
                            </g>
                        </svg>
                    </div>
					<?php if ( $icon2_title ) { ?>
                        <div class="schedule-block-top__item-title"><?php echo $icon2_title; ?></div>
					<?php } ?>
					<?php if ( $icon2_subtitle ) { ?>
                        <div class="schedule-block-top__item-about"><?php echo strip_tags( $icon2_subtitle, '<strong>' ); ?></div>
					<?php } ?>
                </div>
			<?php } ?>
			<?php if ( $icon3_title || $icon3_subtitle ) { ?>
                <div class="schedule-block-top__item">
                    <div class="schedule-block-top__item-img">
                        <svg xmlns="http://www.w3.org/2000/svg" width="122.59" height="122.59" viewbox="0 0 122.59 122.59">
                            <path d="M114.928,122.59h-61.3a7.56,7.56,0,0,1-7.662-7.662V7.662a7.412,7.412,0,0,1,2.213-5.448A7.387,7.387,0,0,1,53.633,0h61.3a7.412,7.412,0,0,1,5.448,2.213,7.387,7.387,0,0,1,2.213,5.448V114.928a7.56,7.56,0,0,1-7.662,7.662Zm0-114.928h-61.3V114.928h61.3ZM22.986,99.6V22.986a7.56,7.56,0,0,1,7.662-7.662h7.662v7.662H30.648V99.6h7.662v7.662H30.648A7.56,7.56,0,0,1,22.986,99.6ZM0,84.281V38.309a7.465,7.465,0,0,1,2.213-5.387,7.3,7.3,0,0,1,5.448-2.275h7.662v7.662H7.662V84.281h7.662v7.662H7.662a7.412,7.412,0,0,1-5.448-2.213A7.387,7.387,0,0,1,0,84.281Z"
                                  transform="translate(0 122.59) rotate(-90)"></path>
                        </svg>
                    </div>
					<?php if ( $icon3_title ) { ?>
                        <div class="schedule-block-top__item-title"><?php echo $icon3_title; ?></div>
					<?php } ?>
					<?php if ( $icon3_subtitle ) { ?>
                        <div class="schedule-block-top__item-about"><?php echo $icon3_subtitle; ?></div>
					<?php } ?>
                </div>
			<?php } ?>
			<?php if ( $icon4_title || $icon4_subtitle ) { ?>
                <div class="schedule-block-top__item">
                    <div class="schedule-block-top__item-img">
                        <svg xmlns="http://www.w3.org/2000/svg" width="101.216" height="109.65" viewbox="0 0 101.216 109.65">
                            <path d="M97.281,10.685H80.412V2.25H71.977v8.435H38.239V2.25H29.8v8.435H12.935A8.457,8.457,0,0,0,4.5,19.119v84.346a8.457,8.457,0,0,0,8.435,8.435H97.281a8.457,8.457,0,0,0,8.435-8.435V19.119A8.457,8.457,0,0,0,97.281,10.685Zm0,92.781H12.935V44.423H97.281Zm0-67.477H12.935V19.119H29.8v8.435h8.435V19.119H71.977v8.435h8.435V19.119H97.281Z" transform="translate(-4.5 -2.25)"></path>
                        </svg>
                    </div>
					<?php if ( $icon4_title ) { ?>
                        <div class="schedule-block-top__item-title"><?php echo $icon4_title; ?></div>
					<?php } ?>
					<?php if ( $icon4_subtitle ) { ?>
                        <div class="schedule-block-top__item-about"><?php echo $icon4_subtitle; ?></div>
					<?php } ?>
                </div>
			<?php } ?>
        </div>
        <div class="schedule-block-body">
			<?php
			foreach ( $program_posts as $post ) {
				setup_postdata( $post );

				$speacker    = false;
				$speacker_id = get_post_meta( $post->ID, 'speacker_id', 1 );
				if ( $speacker_id ) {
					$speacker = get_post( $speacker_id );
				}

				$div_class = 'schedule-block-item';
				if ( get_post_meta( $post->ID, 'is_bonus', 1 ) ) {
					$div_class .= ' schedule-block-item_additional';
				}
				?>
                <div class="<?php echo $div_class; ?>">
                    <div class="schedule-block-item__description">
                        <div class="schedule-block-item__description-title">
                            <strong><?php echo $post->post_title; ?></strong>
							<?php if ( $sub_title = get_post_meta( $post->ID, 'sub_title', 1 ) ) { ?>
                                <span><?php echo $sub_title; ?></span>
							<?php } ?>
                        </div>
						<?php if ( $speacker ) { ?>
                            <div class="schedule-block-item__description-author">
								<?php if ( $img_id = get_post_thumbnail_id( $speacker ) ) { ?>
                                    <div class="schedule-block-item__description-author-photo">
										<?php echo wp_get_attachment_image( $img_id, 'medium', false, [ 'alt' => $speacker->post_title ] ); ?>
                                    </div>
								<?php } ?>
                                <div class="schedule-block-item__description-author-name"><?php echo $speacker->post_title; ?></div>
								<?php if ( $speacker->post_content ) { ?>
                                    <div class="schedule-block-item__description-author-position"><?php echo nl2br( $speacker->post_content ); ?></div>
								<?php } ?>
                            </div>
						<?php } ?>
                    </div>
                    <div class="schedule-block-item__about">
                        <div class="schedule-block-item__about-title">
							<?php echo apply_filters( 'the_content', $post->post_content ); ?>
                        </div>
                    </div>
                </div>
				<?php
			}
			wp_reset_postdata();
			?>
			<?php
			if ( ! is_page_template( 'templates/template-programs.php' ) ) {
				$block_height = get_theme_mod( 'home_programs_height', 550 );
				$label_open   = get_theme_mod( 'home_programs_label_open', Helper::get_default_theme_data( 'home_programs_label_open' ) );
				$label_close  = get_theme_mod( 'home_programs_label_close', Helper::get_default_theme_data( 'home_programs_label_close' ) );
				?>
                <button class="btn_expand js-hide" type="button" data-text-open="<?php echo $label_open; ?>" data-text-close="<?php echo $label_close; ?>" data-height="<?php echo $block_height; ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                        <g fill="none">
                            <path d="M4 9l8 8l8-8" stroke="#626262" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"></path>
                        </g>
                    </svg>
                    <span><?php echo $label_open; ?></span>
                </button>
				<?php
			}
			?>
        </div>
    </div>
</div>