<?php
$block_enabled = get_theme_mod( 'home_prodwescle_enabled', false );
if ( ! $block_enabled ) {
	return;
}

if ( is_front_page() ) {
	if ( ! get_theme_mod( 'home_prodwescle_enabled_home', true ) ) {
		return;
	}
}

$title      = get_theme_mod( 'home_prodwescle_title' );
$title_type = get_theme_mod( 'home_prodwescle_title_type', 'div' );
$text       = get_theme_mod( 'home_prodwescle_text' );
$link       = '';
$link_id    = get_theme_mod( 'home_prodwescle_link_id', 0 );
if ( $link_id ) {
	$link = get_permalink( $link_id );
}
$link_text = get_theme_mod( 'home_prodwescle_link_text', Helper::get_default_theme_data( 'home_prodwescle_link_text' ) );
$more_text = get_theme_mod( 'home_prodwescle_more_text', Helper::get_default_theme_data( 'home_prodwescle_more_text' ) );

$posts_per_page = get_theme_mod( 'home_prodwescle_limit', 8 );
$args           = [
	'post_type'      => 'product_wescle',
	'post_status'    => 'publish',
	'posts_per_page' => $posts_per_page,
	'tax_query'      => [],
	'orderby'        => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
];

$cat_include   = get_theme_mod( 'home_prodwescle_category', [] );
$posts_include = get_theme_mod( 'home_prodwescle_posts', [] );

if ( $posts_include && $posts_include[0] ) {
	$args['post__in']       = $posts_include;
	$args['posts_per_page'] = count( $posts_include );
}
elseif ( $cat_include && $cat_include[0] ) {
	$args['tax_query'][] = [
		'taxonomy' => 'productcat_wescle',
		'terms'    => $cat_include,
	];
}

$query_prodwescle = new WP_Query( $args );
$posts_prodwescle = $query_prodwescle->posts;

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_prodwescle_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_prodwescle_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_prodwescle_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="products-section<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_prodwescle_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="products-section__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
		<?php if ( $text || $link ) { ?>
            <div class="products-section__about">
                <div class="products-section__text"><?php echo $text; ?></div>
				<?php if ( $link && $link_text ) { ?>
                    <a class="products-section__link" href="<?php echo $link; ?>"><?php echo $link_text; ?></a>
				<?php } ?>
            </div>
		<?php } ?>
        <div class="products-section__grid">
			<?php
			foreach ( $posts_prodwescle as $post ) {
				setup_postdata( $post );

				get_template_part( 'template-parts/content/product', 'item' );
			}
			wp_reset_postdata();
			?>
        </div>
		<?php if ( $more_text && $query_prodwescle->max_num_pages > 1 ) { ?>
            <div class="products-section__more">
                <a class="btn btn-main btn-prodwescle-more" href="#" data-paged="1" data-args="<?php echo htmlspecialchars( json_encode( $query_prodwescle->query_vars ), ENT_QUOTES, 'UTF-8' ); ?>"><?php echo $more_text; ?></a>
            </div>
		<?php } ?>
    </div>
</div>