<?php
if ( ! Helper::is_woocommerce_active() ) {
	return;
}

$block_attributes = $args['block_attributes'] ?? '';
$key_block        = isset( $args['key_block'] ) ? '-' . $args['key_block'] : '';

if ( $block_attributes ) {
	$block = $args['block'] ?? [];

	$title      = str_replace( '%', '%%', $block['woo_block_title'] );
	$title_type = $block['woo_block_title_type'];
	$text       = $block['woo_block_text'];

	$link    = $block['woo_block_link_url'];
	$link_id = $block['woo_block_link_id'];
	if ( $link_id ) {
		$link = get_permalink( $link_id );
	}
	$link_text = $block['woo_block_link_text'];

	$block_tab_items = $block_attributes['services'];
	if ( ! $block_tab_items ) {
		return;
	}

	$tabs_items = [];
	foreach ( $block_tab_items as $item ) {
		$woo_block_category = [];
		if ( isset( $item['productsByCategories'] ) ) {
			foreach ( $item['productsByCategories'] as $item ) {
				$woo_block_category[] = $item['id'];
			}
		}

		$tabs_items[] = [
			'tab_block_title'                  => $item['title'],
			'tab_block_product_type'           => $item['productsType'],
			'tab_block_product_stock_enabled'  => $item['showProductAvailability'],
			'tab_block_product_rating_enabled' => $item['showProductRating'],
			'tab_block_category'               => $woo_block_category,
			'tab_block_limit'                  => $item['goodsOnPage'],
			'tab_block_products'               => $item['productsByID'],
			'tab_block_grid_count'             => $item['goodsOnRow'],
		];
	}

	$style_bg = '';
	if ( $color_bg = $block['woo_block_color_bg'] ) {
		$style_bg = 'style="background-color:' . $color_bg . ';"';
	}

	$style_title = '';
	if ( $color = $block['woo_block_color_title'] ) {
		$style_title = 'style="color:' . $color . ';"';
	}

	$section_class = $block['section_class'] ?? '';
}
else {
	$block_enabled = get_theme_mod( 'product_tabs_enabled' );
	if ( ! $block_enabled ) {
		return;
	}

	$title      = get_theme_mod( 'product_tabs_title' );
	$title_type = get_theme_mod( 'product_tabs_title_type', 'div' );
	$text       = get_theme_mod( 'product_tabs_text' );

	$link    = get_theme_mod( 'product_tabs_link_url' );
	$link_id = get_theme_mod( 'product_tabs_link_id' );
	if ( $link_id ) {
		$link = get_permalink( $link_id );
	}
	$link_text = get_theme_mod( 'product_tabs_link_text' );

	$tabs_items = get_theme_mod( 'product_tabs_items' );
	if ( ! $tabs_items ) {
		return;
	}

	$style_bg = '';
	if ( $color_bg = get_theme_mod( 'product_tabs_color_bg' ) ) {
		$style_bg = 'style="background-color:' . $color_bg . ';"';
	}

	$style_title = '';
	if ( $color = get_theme_mod( 'product_tabs_color_title' ) ) {
		$style_title = 'style="color:' . $color . ';"';
	}

	$section_class    = '';
	$section_position = get_theme_mod( 'product_tabs_position_content', 'default' );
	if ( 'default' != $section_position ) {
		$section_class .= ' _section-' . $section_position;
	}
}
?>
<div class="goods-slider-section goods-noslider _tabs<?php echo $section_class; ?>" id="goods-tabs<?php echo $key_block; ?>" <?php echo $style_bg; ?>>
	<?php
	if ( $block_attributes ) {
		wescle_blocks_bg_image( $block_attributes );
	}
	else {
		echo wescle_home_block_bg_image( 'product_tabs_image_bg' );
	}
	?>
    <div class="container">
        <div class="goods-slider-section__header _section-about">
            <div class="goods-slider-section__about">
				<?php
				if ( $title ) {
					printf( '<%1$s class="goods-slider-section__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
				}
				?>
				<?php if ( $text ) { ?>
                    <div class="goods-slider-section__text"><?php echo $text; ?></div>
				<?php } ?>
            </div>
			<?php if ( $link && $link_text ) { ?>
                <a class="goods-slider-section__link" href="<?php echo esc_url( $link ); ?>"><?php echo esc_html( $link_text ); ?></a>
			<?php } ?>
        </div>
        <div class="_tabs-nav">
			<?php
			foreach ( $tabs_items as $key => $block ) {
				$active_class = '';
				if ( $key == 0 ) {
					$active_class = ' _active';
				}
				echo '<button class="_tabs-item' . $active_class . '" type="button"><span>' . $block['tab_block_title'] . '</span></button>';
			}
			?>
        </div>
        <div class="_tabs-body">
			<?php
			foreach ( $tabs_items as $key => $block ) {
				$active_class = '';
				if ( $key == 0 ) {
					$active_class = ' _active';
				}

				$products_type = $block['tab_block_product_type'];
				$limit         = intval( $block['tab_block_limit'] );
				if ( $limit < 1 ) {
					$limit = 10;
				}
				$product_args = [
					'post_type'        => 'product',
					'posts_per_page'   => $limit,
					'tax_query'        => [],
					'orderby'          => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
					'suppress_filters' => false
				];

				if ( 'custom' == $products_type ) {
					if ( $block['tab_block_category'] && $block['tab_block_category'][0] ) {
						$product_args['tax_query'][] = [
							'taxonomy' => 'product_cat',
							'terms'    => $block['tab_block_category']
						];
					}

					if ( $block['tab_block_products'] ) {
						unset( $product_args['tax_query'] );

						if ( is_string( $block['tab_block_products'] ) ) {
							$block['tab_block_products'] = explode( ',', str_replace( ' ', '', $block['tab_block_products'] ) );
						}

						$product_args['posts_per_page'] = count( $block['tab_block_products'] );
						$product_args['post__in']       = $block['tab_block_products'];
						$product_args['orderby']        = 'post__in';
					}
				}

				if ( 'new' == $products_type ) {
					$product_args['orderby'] = [ 'date' => 'DESC' ];
				}
				if ( 'sale' == $products_type ) {
					$product_args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
					$product_args['orderby']  = 'post__in';
				}
				if ( 'views' == $products_type ) {
					$product_args['meta_key'] = 'views';
					$product_args['orderby']  = [ 'meta_value_num' => 'DESC' ];

					if ( Helper::is_plugin_active( 'post-views-counter/post-views-counter.php' ) ) {
						$product_args['suppress_filters'] = false;
						$product_args['orderby']          = 'post_views';
						$product_args['fields']           = '';
						$product_args['meta_key']         = '';
					}
				}
				if ( 'popular' == $products_type ) {
					$product_args['meta_key'] = 'total_sales';
					$product_args['orderby']  = [ 'meta_value_num' => 'DESC' ];
				}

				$posts_product = get_posts( apply_filters( 'tab_block_products_args', $product_args ) );

				$is_show_stock  = $block['tab_block_product_stock_enabled'];
				$is_show_rating = $block['tab_block_product_rating_enabled'];

				$grid_count = $block['tab_block_grid_count'] ?? 5;
				?>
                <div class="goods-slider-section__grid _grid-<?php echo $grid_count; ?> _tabs-block<?php echo $active_class; ?>">
					<?php
					$item_args = [
						'is_show_stock'  => $is_show_stock,
						'is_show_rating' => $is_show_rating,
						'isset_slider'   => false,
					];

					if ( ! $is_show_stock ) {
						remove_action( 'woocommerce_shop_loop_item_title', 'wescle_loop_stock_product', 5 );
						remove_action( 'woocommerce_before_shop_loop_item_title', 'wescle_loop_stock_product', 5 );
					}
					else {
						add_action( 'woocommerce_shop_loop_item_title', 'wescle_loop_stock_product', 5 );
						add_action( 'woocommerce_before_shop_loop_item_title', 'wescle_loop_stock_product', 5 );
					}
					if ( ! $is_show_rating ) {
						remove_action( 'woocommerce_shop_loop_item_title', 'wescle_loop_rating_product', 5 );
						remove_action( 'woocommerce_before_shop_loop_item_title', 'wescle_loop_rating_product', 5 );
					}
					else {
						add_action( 'woocommerce_shop_loop_item_title', 'wescle_loop_rating_product', 5 );
						add_action( 'woocommerce_before_shop_loop_item_title', 'wescle_loop_rating_product', 5 );
					}

					foreach ( $posts_product as $post ) {
						setup_postdata( $post );

						get_template_part( 'template-parts/section/woo-products', 'item', $item_args );
					}
					wp_reset_postdata();
					?>
                </div>
				<?php
			}
			?>
        </div>
    </div>
</div>