<?php
$block_enabled = get_theme_mod( 'home_prices_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$title       = get_theme_mod( 'home_prices_title' );
$title_type  = get_theme_mod( 'home_prices_title_type', 'div' );
$text        = get_theme_mod( 'home_prices_text' );
$price_items = get_theme_mod( 'home_prices_items', [] );
if ( ! $price_items ) {
	return;
}

$image_fullwidth = get_theme_mod( 'home_prices_image_fullwidth' );

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_prices_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_prices_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$btn_flare = '';
if ( get_theme_mod( 'prices_button_type' ) == 'animation' ) {
	$btn_flare = 'btn-flare ';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_prices_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="tarrif-plan tarrif-plan1 section-paddings<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_prices_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="tarrif-plan__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
		<?php if ( $text ) { ?>
            <div class="_section-about">
                <div class="_section-about__text"><?php echo $text; ?></div>
            </div>
		<?php } ?>
        <div class="tarrif-plan__row  tarrif-plan__count-<?php echo count( $price_items ); ?>">
			<?php foreach ( $price_items as $key => $item ) { ?>
				<?php
				$img = '';
				if ( $item['image'] ) {
					$size = get_theme_mod( 'home_prices_image_size', 'medium' );
					$img  = wp_get_attachment_image( $item['image'], $size );
				}

				$text_plus  = preg_split( '/\r\n|[\r\n]/', $item['text_plus'] );
				$text_minus = preg_split( '/\r\n|[\r\n]/', $item['text_minus'] );

				$class = 'tarrif-plan-item';
				if ( isset( $item['recommended'] ) && $item['recommended'] ) {
					$class .= ' tarrif-plan-item_recommended';
				}
				if ( isset( $item['image_center'] ) && $item['image_center'] ) {
					$class .= ' tarrif-plan-icon_center';
				}

				if ( $image_fullwidth ) {
					$class .= ' tarrif-plan-icon_fullwidth';
				}

				if ( strpos( $img, '.svg' ) !== false ) {
					$class .= ' tarrif-plan-icon_svg';
				}
				?>
                <div class="tarrif-plan__col">
                    <div class="<?php echo $class; ?>">
                        <div class="tarrif-plan-item__img">
							<?php echo $img; ?>
                        </div>
                        <div class="tarrif-plan-item__title"><?php echo $item['title']; ?></div>
                        <ul class="tarrif-plan-item__points">
							<?php
							if ( $text_plus ) {
								foreach ( $text_plus as $line ) {
									if ( ! $line ) {
										continue;
									}
									?>
                                    <li>
                                        <svg role="img" xmlns="http://www.w3.org/2000/svg" width="48px" height="48px" viewbox="0 0 24 24" stroke="green" stroke-width="1" stroke-linecap="square" stroke-linejoin="miter" fill="none" color="green">
                                            <title>OK</title>
                                            <polyline points="7 13 10 16 17 9"></polyline>
                                            <circle cx="12" cy="12" r="10"></circle>
                                        </svg>
                                        <span><?php echo $line; ?></span>
                                    </li>
									<?php
								}
							}
							if ( $text_minus ) {
								foreach ( $text_minus as $line ) {
									if ( ! $line ) {
										continue;
									}
									?>
                                    <li>
                                        <svg role="img" xmlns="http://www.w3.org/2000/svg" width="48px" height="48px" viewbox="0 0 24 24" stroke="red" stroke-width="1" stroke-linecap="square" stroke-linejoin="miter" fill="none" color="red">
                                            <title>Cancel</title>
                                            <path d="M15.5355339 15.5355339L8.46446609 8.46446609M15.5355339 8.46446609L8.46446609 15.5355339"></path>
                                            <path d="M4.92893219,19.0710678 C1.02368927,15.1658249 1.02368927,8.83417511 4.92893219,4.92893219 C8.83417511,1.02368927 15.1658249,1.02368927 19.0710678,4.92893219 C22.9763107,8.83417511 22.9763107,15.1658249 19.0710678,19.0710678 C15.1658249,22.9763107 8.83417511,22.9763107 4.92893219,19.0710678 Z"></path>
                                        </svg>
                                        <span><?php echo $line; ?></span>
                                    </li>
									<?php
								}
							}
							?>
                        </ul>
                        <div class="tarrif-plan-item__bottom">
                            <div class="tarrif-plan-item__price"><?php echo $item['price']; ?>
			                    <?php
			                    if ( isset( $item['price_old'] ) && $item['price_old'] ) {
				                    echo '<span class="price_old">' . $item['price_old'] . '</span>';
			                    }
			                    ?>
                            </div>
                            <div class="tarrif-plan-item__bottom-btns">
			                    <?php
			                    if ( $item['button_url'] ) {
				                    $class_popup = '';
				                    if ( strpos( $item['button_url'], '#wescle-modal' ) !== false || strpos( $item['button_url'], '#modal' ) !== false ) {
					                    $class_popup = '_popup-link';
				                    }
				                    ?>
                                    <a class="tarrif-plan-item__btn btn btn-main <?php echo $btn_flare; ?><?php echo $class_popup; ?>" href="<?php echo $item['button_url']; ?>"><span><?php echo $item['button_label']; ?></span></a>
			                    <?php } ?>
			                    <?php
			                    if ( isset( $item['button2_url'] ) && $item['button2_url'] ) {
				                    $class_popup = '';
				                    if ( strpos( $item['button2_url'], '#wescle-modal' ) !== false || strpos( $item['button2_url'], '#modal' ) !== false ) {
					                    $class_popup = '_popup-link';
				                    }
				                    ?>
                                    <a class="tarrif-plan-item__btn btn btn-main <?php echo $btn_flare; ?><?php echo $class_popup; ?>" href="<?php echo $item['button2_url']; ?>"><span><?php echo $item['button2_label']; ?></span></a>
			                    <?php } ?>
                            </div>
                        </div>
	                    <?php if ( isset( $item['action_label'] ) ) { ?>
		                    <?php html_timer_block( 'tarrif-plan-timer-1-' . $key, $item['action_label'], $item['action_date'], $item['action_hours'] ); ?>
	                    <?php } ?>
                    </div>
                </div>
			<?php } ?>
        </div>
    </div>
</div>