<?php
$block_enabled = get_theme_mod( 'home_price_table_enabled', false );
if ( ! $block_enabled ) {
	return;
}

if ( is_front_page() ) {
	if ( ! get_theme_mod( 'home_price_table_enabled_home', true ) ) {
		return;
	}
}

$title            = get_theme_mod( 'home_price_table_title' );
$title_type       = get_theme_mod( 'home_price_table_title_type', 'div' );
$text             = get_theme_mod( 'home_price_table_text' );
$package_post_ids = get_theme_mod( 'home_price_table_posts', [] );
if ( count( $package_post_ids ) == 1 && $package_post_ids[0] == '' ) {
	$package_post_ids = [];
}
$button_label = get_theme_mod( 'home_price_table_button', Helper::get_default_theme_data( 'home_price_table_button' ) );

$posts_per_page = 4;
$post__in       = [];
if ( $package_post_ids ) {
	$post__in = $package_post_ids;
}
$package_posts = get_posts( [
	'post_type'        => 'pricepackage_wescle',
	'posts_per_page'   => $posts_per_page,
	'post__in'         => $post__in,
	'orderby'          => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
	'suppress_filters' => false
] );
if ( ! $package_posts ) {
	return;
}

$package_thead_data = [
	get_theme_mod( 'home_price_table_title_list' )
];
foreach ( $package_posts as $item_post ) {
	$package_thead_data[ $item_post->ID ] = $item_post->post_title;
}

$package_tbody_data = [];
$option_posts       = get_posts( [
	'post_type'        => 'optionpackage_wescle',
	'posts_per_page'   => - 1,
	'orderby'          => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
	'suppress_filters' => false
] );
foreach ( $option_posts as $option_post ) {
	$package_tbody_data[ $option_post->ID ]          = [];
	$package_tbody_data[ $option_post->ID ]['title'] = $option_post->post_title;
}


$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_price_table_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_price_table_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$btn_flare = '';
if ( get_theme_mod( 'price_table_button_type' ) == 'animation' ) {
	$btn_flare = 'btn-flare ';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_price_table_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="packages-include<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_price_table_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="packages-include__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
		<?php if ( $text ) { ?>
            <div class="_section-about">
                <div class="_section-about__text"><?php echo $text; ?></div>
            </div>
		<?php } ?>
        <div class="packages-include__body">
            <div class="main-table-wrap">
                <table class="main-table packages-include__table">
                    <thead>
                    <tr>
						<?php foreach ( $package_thead_data as $key => $th ) { ?>
                            <th class="packages-<?php echo $key; ?>"><?php echo $th; ?></th>
						<?php } ?>
                    </tr>
                    </thead>
                    <tbody>
					<?php
					foreach ( $option_posts as $option_post ) {
						$price_package_ids = get_post_meta( $option_post->ID, 'price_package_ids', 1 );
						if ( ! $price_package_ids ) {
							$price_package_ids = [];
						}
						?>
                        <tr>
                            <td><?php echo $option_post->post_title; ?></td>
							<?php foreach ( $package_posts as $item_post ) { ?>
                                <td class="packages-<?php echo $item_post->ID; ?>">
									<?php if ( in_array( $item_post->ID, $price_package_ids ) ) { ?>
                                        <div class="packages-include__icon">
                                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 16 16">
                                                <g>
                                                    <path fill-rule="evenodd" d="M10.97 4.97a.75.75 0 0 1 1.071 1.05l-3.992 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093l3.473-4.425a.236.236 0 0 1 .02-.022z"></path>
                                                </g>
                                            </svg>
                                        </div>
									<?php } ?>
                                </td>
							<?php } ?>
                        </tr>
					<?php } ?>
                    </tbody>
                    <tfoot>
                    <tr>
                        <td></td>
						<?php foreach ( $package_posts as $item_post ) {
							$price_old  = get_post_meta( $item_post->ID, 'price_old', 1 );
							$price      = get_post_meta( $item_post->ID, 'price', 1 );
							$text_after = get_post_meta( $item_post->ID, 'label_after_button', 1 );

							$url = trim( get_post_meta( $item_post->ID, 'button_url', 1 ) );
							if ( ! $url || $url == '#' ) {
								$url = '#modal-order_package';
							}

							$color_class = '';
							$block_color = get_post_meta( $item_post->ID, 'block_color', 1 );
							if ( $block_color ) {
								$color_class = 'packages-custom_color ';
							}
							?>
                            <td class="packages-include__table-info <?php echo $color_class; ?>packages-<?php echo $item_post->ID; ?>">
								<?php if ( $price_old || $price ) { ?>
                                    <div class="packages-include__table-price">
										<?php if ( $price_old ) { ?>
                                            <span class="packages-include__table-price-old"><?php echo $price_old; ?></span>
										<?php } ?>
                                        <span class="packages-include__table-price-current"><?php echo $price; ?></span>
                                    </div>
								<?php } ?>
								<?php if ( $button_label ) { ?>
									<?php if ( $url == '#modal-order_package' ) { ?>
                                        <a class="btn btn-main btn-order_package _popup-link <?php echo $btn_flare; ?>" data-name="<?php echo esc_attr( $item_post->post_title ); ?>" href="<?php echo $url; ?>"><span><?php echo $button_label; ?></span></a>
									<?php } else { ?>
                                        <span class="btn btn-main js-link <?php echo $btn_flare; ?>" data-link="<?php echo $url; ?>"><span><?php echo $button_label; ?></span></span>
									<?php } ?>
								<?php } ?>
								<?php if ( $text_after ) { ?>
                                    <div class="packages-include__table-residue"><?php echo $text_after; ?></div>
								<?php } ?>
                            </td>
						<?php } ?>
                    </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
</div>