<?php
$block_enabled = get_theme_mod( 'home_price_list_enabled', false );
if ( ! $block_enabled ) {
	return;
}

if ( is_front_page() ) {
	if ( ! get_theme_mod( 'home_price_list_enabled_home', true ) ) {
		return;
	}
}

$title          = get_theme_mod( 'home_price_list_title' );
$title_type     = get_theme_mod( 'home_price_list_title_type', 'div' );
$text           = get_theme_mod( 'home_price_list_text' );
$price_post_ids = get_theme_mod( 'home_price_list_posts', [] );
if ( count( $price_post_ids ) == 1 && $price_post_ids[0] == '' ) {
	$price_post_ids = [];
}

$posts_per_page = - 1;
$post__in       = [];
if ( $price_post_ids && is_front_page() ) {
	$posts_per_page = count( $price_post_ids );
	$post__in       = $price_post_ids;
}
$price_posts = get_posts( [
	'post_type'        => 'price_wescle',
	'posts_per_page'   => $posts_per_page,
	'post__in'         => $post__in,
	'orderby'          => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
	'suppress_filters' => false
] );
if ( ! $price_posts ) {
	return;
}

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_price_list_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_price_list_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

if ( is_page_template( 'templates/template-price_list.php' ) ) {
	$style_bg    = '';
	$style_title = '';
	$title       = '';
	$text        = '';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_price_list_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="price-list<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_price_list_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="price-list__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
		<?php if ( $text ) { ?>
            <div class="price-list__text"><?php echo $text; ?></div>
		<?php } ?>
        <div class="accardeon">
			<?php foreach ( $price_posts as $item ) { ?>
				<?php
				$active_class = get_post_meta( $item->ID, 'is_open', 1 ) ? 'active' : '';
				?>
                <div class="price-list-item">
                    <button class="price-list-item__title accardeon__title <?php echo $active_class; ?>"><span><?php echo $item->post_title; ?></span>
                        <svg class="feather feather-plus" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewbox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <line x1="12" y1="5" x2="12" y2="19"></line>
                            <line x1="5" y1="12" x2="19" y2="12"></line>
                        </svg>
                    </button>
                    <div class="price-list-item__body">
						<?php
						$content = preg_replace( '/<table.+?>/', '<table class="main-table">', $item->post_content );
						$content = str_replace( [ '<table', '</table>' ], [ '<div class="main-table-wrap"><table', '</table></div>' ], $content );
						echo do_shortcode( $content );
						?>
                    </div>
                </div>
			<?php } ?>
        </div>
    </div>
</div>