<?php
$block_enabled = get_theme_mod( 'home_portfolio_enabled', false );
if ( ! $block_enabled ) {
	return;
}

if ( is_front_page() ) {
	if ( ! get_theme_mod( 'home_portfolio_enabled_home', true ) ) {
		return;
	}
}

$title      = get_theme_mod( 'home_portfolio_title' );
$title_type = get_theme_mod( 'home_portfolio_title_type', 'div' );
$text       = get_theme_mod( 'home_portfolio_text' );
$link       = '';
$link_id    = get_theme_mod( 'home_portfolio_link_id', 0 );
if ( $link_id ) {
	$link = get_permalink( $link_id );
}
$link_text            = get_theme_mod( 'home_portfolio_link_text', Helper::get_default_theme_data( 'home_portfolio_link_text' ) );
$home_portfolio_posts = get_theme_mod( 'home_portfolio_posts', [] );
$more_text            = get_theme_mod( 'home_portfolio_more_text', Helper::get_default_theme_data( 'home_portfolio_more_text' ) );

$portfolio_post_ids  = [];
$home_portfolio_data = [];
$portfolio_sizes     = [];
foreach ( $home_portfolio_posts as $item ) {
	if ( $item['post_id'] ) {
		$post_id = apply_filters( 'wpml_object_id', $item['post_id'], 'portfolio_wescle', true );

		$portfolio_post_ids[] = $post_id;

		$size = 'default';
		if ( isset( $item['size'] ) ) {
			$size = $item['size'];
		}
        elseif ( isset( $item['size_portfolio'] ) ) {
			$size = $item['size_portfolio'];
		}
		$home_portfolio_data[ $post_id ]['size'] = $size;
		$portfolio_sizes[]                       = $size;
	}
}

$posts_per_page = get_theme_mod( 'home_portfolio_count', 4 );
$post__in       = [];
$orderby        = 'date';
if ( $portfolio_post_ids ) {
	$posts_per_page = count( $portfolio_post_ids );
	$post__in       = $portfolio_post_ids;
	$orderby        = 'post__in';
}

$portfolio_posts = get_posts( [
	'post_type'        => 'portfolio_wescle',
	'posts_per_page'   => $posts_per_page,
	'post__in'         => $post__in,
	'orderby'          => $orderby,
	'suppress_filters' => false
] );
if ( ! $portfolio_posts ) {
	return;
}

$portfolio_posts_next = get_posts( [
	'post_type'        => 'portfolio_wescle',
	'posts_per_page'   => ( $posts_per_page + 1 ),
	'fields'           => 'ids',
	'suppress_filters' => false
] );

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_portfolio_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_portfolio_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_portfolio_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="work-performed<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_portfolio_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="work-performed__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
        <div class="work-performed__about">
			<?php if ( $text ) { ?>
                <div class="work-performed__text"><?php echo $text; ?></div>
			<?php } ?>
			<?php if ( $link && $link_text ) { ?>
                <a class="work-performed__link" href="<?php echo $link; ?>"><?php echo esc_html( $link_text ); ?></a>
			<?php } ?>
        </div>
        <div class="row work-performed-items">
			<?php
			set_query_var( 'template_args', [ 'portfolio_data' => $home_portfolio_data ] );
			$portfolio_post_ids = [];
			foreach ( $portfolio_posts as $post ) {
				setup_postdata( $post );
				$portfolio_post_ids[] = $post->ID;

				get_template_part( 'template-parts/content/portfolio', 'item' );
			}
			wp_reset_postdata();
			?>
        </div>
		<?php if ( $more_text && count( $portfolio_posts_next ) > $posts_per_page ) { ?>
            <div class="work-performed__more">
                <a class="work-performed__btn btn btn-main btn-more-work" data-paged="1" data-portfolio_sizes="<?php echo implode( ',', $portfolio_sizes ); ?>" data-portfolio_post_ids="<?php echo implode( ',', $portfolio_post_ids ); ?>" href="#"><?php echo $more_text; ?></a>
            </div>
		<?php } ?>
    </div>
</div>