<?php
$block_enabled = get_theme_mod( 'home_performance_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$title          = get_theme_mod( 'home_performance_title' );
$title_type     = get_theme_mod( 'home_performance_title_type', 'div' );
$text           = get_theme_mod( 'home_performance_text' );
$payment_items  = get_theme_mod( 'home_performance_items', [] );
$payment_items2 = get_theme_mod( 'home_performance_items2', [] );
if ( ! $payment_items && ! $payment_items2 ) {
	return;
}
$button_text  = get_theme_mod( 'home_performance_button_text' );
$button_label = get_theme_mod( 'home_performance_button_label' );
$button_url   = get_theme_mod( 'home_performance_button_url' );

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_performance_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_performance_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_performance_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="performance<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_performance_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="performance__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
        <div class="performance__top">
			<?php if ( $text || $button_text || $button_url ) { ?>
                <div class="performance__header _section-about">
                    <div class="performance__header-left">
                        <div class="_section-about__text"><?php echo $text; ?></div>
                    </div>
					<?php if ( $button_text || $button_url ) { ?>
                        <div class="performance__header-right">
                            <div class="performance__buy">
								<?php if ( $button_text ) { ?>
                                    <span class="performance__price-old"><?php echo $button_text; ?></span>
								<?php } ?>
								<?php if ( $button_url ) { ?>
                                    <a class="btn btn-main" href="<?php echo $button_url; ?>"><span><?php echo $button_label; ?></span></a>
								<?php } ?>
                            </div>
                        </div>
					<?php } ?>
                </div>
			<?php } ?>
			<?php if ( $payment_items ) { ?>
                <div class="performance__about">
					<?php foreach ( $payment_items as $item ) { ?>
                        <div class="performance__about-item">
                            <div class="performance__about-item-title">
								<?php
								if ( $item['image'] ) {
									echo wp_get_attachment_image( $item['image'], 'medium' );
								}
								echo '<span>' . $item['title'] . '</span>';
								?>
                            </div>
							<?php if ( $item['text'] ) { ?>
                                <div class="performance__about-item-text"><?php echo $item['text']; ?></div>
							<?php } ?>
                        </div>
					<?php } ?>
                </div>
			<?php } ?>
        </div>
		<?php if ( $payment_items2 ) { ?>
            <div class="performance__bottom">
				<?php foreach ( $payment_items2 as $item ) { ?>
                    <div class="performance-item">
						<?php if ( $item['image'] ) { ?>
                            <div class="performance-item__img">
								<?php echo wp_get_attachment_image( $item['image'], 'medium' ); ?>
                            </div>
						<?php } ?>
						<?php if ( $item['title'] ) { ?>
                            <div class="performance-item__title"><?php echo $item['title']; ?></div>
						<?php } ?>
						<?php if ( $item['text'] ) { ?>
                            <div class="performance-item__text"><?php echo $item['text']; ?></div>
						<?php } ?>
                    </div>
				<?php } ?>
            </div>
		<?php } ?>
    </div>
</div>