<?php
$block_enabled = get_theme_mod( 'home_payments_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$title         = get_theme_mod( 'home_payments_title' );
$title_type    = get_theme_mod( 'home_payments_title_type', 'div' );
$text          = get_theme_mod( 'home_payments_text' );
$payment_items = get_theme_mod( 'home_payments_items', [] );
if ( ! $payment_items ) {
	return;
}

$data_args   = [];
$data_args[] = 'data-slides-count="' . get_theme_mod( 'home_payments_count_slide', 3 ) . '"';
if ( get_theme_mod( 'home_payments_autoplay' ) ) {
	$data_args[] = 'data-autoplay="true"';
	$speed       = get_theme_mod( 'home_payments_autoplay', 6 ) * 1000;
	$data_args[] = 'data-autoplay-speed="' . $speed . '"';
}
$data_args = implode( ' ', $data_args );

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_payments_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_payments_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_payments_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="payment-methods<?php echo $section_class; ?>" <?php echo $style_bg; ?> <?php echo $data_args; ?>>
	<?php echo wescle_home_block_bg_image( 'home_payments_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="payment-methods__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
		<?php if ( $text ) { ?>
            <div class="_section-about">
                <div class="_section-about__text"><?php echo $text; ?></div>
            </div>
		<?php } ?>
        <div class="swiper payment-methods-swiper">
            <div class="swiper-wrapper">
				<?php foreach ( $payment_items as $item ) { ?>
					<?php
					$style_title = isset( $item['color_title'] ) && $item['color_title'] ? ' style="color:' . $item['color_title'] . '"' : '';
					$style_text  = isset( $item['color_text'] ) && $item['color_text'] ? ' style="color:' . $item['color_text'] . '"' : '';
					$style_bg    = isset( $item['color_bg'] ) && $item['color_bg'] ? ' style="background-color:' . $item['color_bg'] . '"' : '';

					$tag_open  = '<div class="payment-methods-item"' . $style_bg . '>';
					$tag_close = '</div>';
					if ( $item['url'] ) {
						$tag_open  = '<a class="payment-methods-item"' . $style_bg . ' href="' . $item['url'] . '" target="_blank" rel="noopener noreferrer">';
						$tag_close = '</a>';
					}
					?>
                    <div class="swiper-slide">
						<?php echo $tag_open; ?>
						<?php if ( $item['image_bg'] ) { ?>
                            <div class="payment-methods-item__img">
								<?php echo wp_get_attachment_image( $item['image_bg'], 'medium' ); ?>
                            </div>
						<?php } ?>
                        <div class="payment-methods-item__body">
                            <div class="payment-methods-item__logos">
                                <div class="payment-methods-item__logo">
									<?php echo wp_get_attachment_image( $item['image'], 'medium' ); ?>
                                </div>
                            </div>
                            <div class="payment-methods-item__title"<?php echo $style_title; ?>><?php echo $item['title']; ?></div>
							<?php if ( $item['text'] ) { ?>
                                <div class="payment-methods-item__text"<?php echo $style_text; ?>><?php echo $item['text']; ?></div>
							<?php } ?>
							<?php if ( $item['url'] ) { ?>
                                <div class="payment-methods-item__arrow">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="30" height="16" viewbox="0 0 30 16" fill="none">
                                        <path d="M22 1L29 8M29 8L22 15M29 8H1" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>
                                </div>
							<?php } ?>
                        </div>
						<?php echo $tag_close; ?>
                    </div>
				<?php } ?>
            </div>
        </div>
    </div>
</div>