<?php
$block_enabled = get_theme_mod( 'home_partners_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$title      = get_theme_mod( 'home_partners_title' );
$title_type = get_theme_mod( 'home_partners_title_type', 'div' );

$text  = get_theme_mod( 'home_partners_text' );
$items = get_theme_mod( 'home_partners_images', [] );

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_partners_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_partners_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$slides_count         = get_theme_mod( 'home_partners_settings_count', 4 );
$slider_speed         = get_theme_mod( 'home_partners_settings_speed', 8 );
$slider_speed         = $slider_speed * 1000;
$slider_dots          = get_theme_mod( 'home_partners_settings_dots', false ) == true ? 'true' : 'false';
$slider_arrows        = get_theme_mod( 'home_partners_settings_arrow', true ) == true ? 'true' : 'false';
$slider_arrows_mobile = get_theme_mod( 'home_partners_settings_arrow_mobile', true ) == true ? '' : '_hide-arrows-mobile';

$section_class    = '';
$section_position = get_theme_mod( 'home_partners_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="our-partners<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_partners_image_bg' ); ?>
    <div class="container">
        <div class="slider-wrapper <?php echo $slider_arrows_mobile; ?>">
            <div class="our-partners__top">
                <div class="our-partners__about">
					<?php
					if ( $title ) {
						printf( '<%1$s class="our-partners__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
					}
					?>
					<?php if ( $text ) { ?>
                        <div class="our-partners__text"><?php echo $text; ?></div>
					<?php } ?>
                </div>
                <div class="our-partners__buttons slider-buttons">
                    <button class="slider-buttons__item slider-buttons__item_prev" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(180deg); -webkit-transform: rotate(180deg); transform: rotate(180deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                            <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                        </svg>
                    </button>
                    <button class="slider-buttons__item slider-buttons__item_next" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                            <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                        </svg>
                    </button>
                </div>
            </div>
			<?php if ( $items ) { ?>
                <div class="our-partners__slider" data-slides="<?php echo $slides_count; ?>" data-autoplay-speed="<?php echo $slider_speed; ?>" data-dots="<?php echo $slider_dots; ?>" data-arrows="<?php echo $slider_arrows; ?>">
					<?php
					foreach ( $items as $item ) {
						if ( ! $item['image_id'] ) {
							continue;
						}

						$format = '<div class="our-partners-item__image">%1$s</div>';
						if ( $item['link'] ) {
							$format = '<div class="our-partners-item__image js-link" data-link="' . $item['link'] . '">%1$s</div>';
						}
						?>
                        <div class="our-partners__slide">
                            <div class="our-partners-item">
								<?php printf( $format, wp_get_attachment_image( $item['image_id'], 'medium' ) ); ?>
                            </div>
                        </div>
						<?php
					}
					?>
                </div>
			<?php } ?>
        </div>
    </div>
</div>