<?php
$block_enabled = get_theme_mod( 'home_mosaic_enabled' );

if ( ! $block_enabled ) {
	return;
}

if ( is_front_page() ) {
	if ( ! get_theme_mod( 'home_mosaic_enabled_home', true ) ) {
		return;
	}
}

$title        = get_theme_mod( 'home_mosaic_title' );
$title_type   = get_theme_mod( 'home_mosaic_title_type', 'div' );
$text         = get_theme_mod( 'home_mosaic_text' );
$link         = get_theme_mod( 'home_mosaic_button_url', '' );
$link_text    = get_theme_mod( 'home_mosaic_button_title', '' );
$target_blank = get_theme_mod( 'home_mosaic_target_blank' ) ? 'target="_blank" rel="noopener noreferrer"' : '';
$more_text    = get_theme_mod( 'home_mosaic_more_text' );

$items = get_theme_mod( 'home_mosaic_items', [] );

$term_ids = wp_list_pluck( $items, 'faq_cat' );
$terms    = get_terms( [
	'taxonomy' => 'mosaiccat_wescle',
	'include'  => $term_ids,
	'orderby'  => 'include'
] );
if ( ! $terms ) {
	return;
}
$terms = array_values( $terms );

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_mosaic_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_mosaic_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_mosaic_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="wescle-places<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_mosaic_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="wescle-places__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
	    <?php if ( $text ) { ?>
            <div class="wescle-places__about _section-about">
                <div class="_section-about__text"><?php echo $text; ?></div>
			    <?php if ( $link && $link_text ) { ?>
                    <a class="wescle-places__link" href="<?php echo $link; ?>" <?php echo $target_blank; ?>><?php echo $link_text; ?></a>
			    <?php } ?>
            </div>
	    <?php } ?>
	    <?php get_template_part( 'template-parts/home/mosaic-tabs', null, [ 'terms' => $terms, 'more_text' => $more_text, 'per_page' => get_theme_mod( 'home_mosaic_count', 12 ) ] ); ?>
    </div>
</div>

