<?php
$terms     = $args['terms'] ?? [];
$per_page  = $args['per_page'] ?? 12;
$more_text = $args['more_text'] ?? '';
?>
<div class="_tabs">
	<?php if ( count( $terms ) > 1 ) { ?>
        <div class="_tabs-nav">
			<?php
			foreach ( $terms as $key => $term ) {
				$class = $key == 0 ? ' _active' : '';
				echo '<button class="btn btn-main _tabs-item' . $class . '" type="button">' . $term->name . '</button>';
			}
			?>
        </div>
	<?php } ?>
    <div class="_tabs-body">
		<?php
		foreach ( $terms as $key => $term ) {
			$class = $key == 0 ? ' _active' : '';

			echo '<div class="_tabs-block' . $class . '"><div class="wescle-places__grid">';

			$args         = [
				'post_type'        => 'mosaic_wescle',
				'posts_per_page'   => $per_page,
				'orderby'          => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
				'tax_query'        => [
					[
						'taxonomy' => $term->taxonomy,
						'terms'    => [ $term->term_id ],
					]
				],
				'suppress_filters' => false
			];
			$custom_query = new WP_Query( $args );
			$mosaic_posts = $custom_query->posts;

			foreach ( $mosaic_posts as $post ) {
				setup_postdata( $post );

				get_template_part( 'template-parts/content/mosaic-item' );
			}

			echo '</div>';

			if ( $more_text && $custom_query->max_num_pages > 1 ) {
				echo '<div class="wescle-places__more"><a class="btn btn-main btn-mosaic-more" href="#" data-paged="1" data-args="' . htmlspecialchars( json_encode( $custom_query->query_vars ), ENT_QUOTES, 'UTF-8' ) . '">' . $more_text . '</a></div>';
			}

			echo '</div>';
		}
		wp_reset_postdata();
		?>
    </div>
</div>