<?php
$block_enabled = get_theme_mod( 'home_map_enabled' );
if ( ! $block_enabled ) {
	return;
}

$title      = get_theme_mod( 'home_map_title' );
$title_type = get_theme_mod( 'home_map_title_type', 'div' );
$text       = get_theme_mod( 'home_map_text' );

$is_fullwidth = get_theme_mod( 'home_map_fullwidth' );
$is_nopadding = get_theme_mod( 'home_map_nopadding' );

$items = get_theme_mod( 'home_map_items', [] );
if ( ! $items ) {
	return;
}

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_map_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_map_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_map_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
if ( $is_fullwidth ) {
	$section_class .= ' _fullscreen';
}
if ( $is_nopadding ) {
	$section_class .= ' _without-padding';
}
?>
<div class="wescle-map<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_map_image_bg' ); ?>
    <div class="wescle-map__description">
        <div class="container">
			<?php
			if ( $title ) {
				printf( '<%1$s class="title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
			<?php if ( $text ) { ?>
                <div class="_section-about">
                    <div class="_section-about__text"><?php echo $text; ?></div>
                </div>
			<?php } ?>
        </div>
    </div>

    <div class="wescle-map__main">
        <div class="container">
			<?php if ( count( $items ) == 1 ) { ?>
				<?php
				foreach ( $items as $item ) {
					$map_class = $item['map_dark'] ? ' _map_dark' : '';
					?>
                    <div class="_map<?php echo $map_class; ?>" data-src="<?php echo $item['map_url']; ?>"></div>
					<?php
				}
				?>
			<?php } else { ?>
                <div class="_tabs">
                    <div class="container">
                        <div class="_tabs-nav">
							<?php foreach ( $items as $key => $item ) {
								$class = $key == 0 ? ' _active' : '';
								?>
                                <button class="btn btn-main _tabs-item<?php echo $class; ?>" type="buttons">
                                    <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img" width="1em" height="1em" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                        <g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                                            <circle cx="12" cy="10" r="3"></circle>
                                            <path d="M12 2a8 8 0 0 0-8 8c0 1.892.402 3.13 1.5 4.5L12 22l6.5-7.5c1.098-1.37 1.5-2.608 1.5-4.5a8 8 0 0 0-8-8Z"></path>
                                        </g>
                                    </svg>
                                    <span><?php echo $item['map_title']; ?></span>
                                </button>
							<?php } ?>
                        </div>
                    </div>
                    <div class="_tabs-body">
		                <?php
		                foreach ( $items as $key => $item ) {
			                $class     = $key == 0 ? ' _active' : '';
			                $map_class = $item['map_dark'] ? ' _map_dark' : '';
			                ?>
                            <div class="_tabs-block<?php echo $class; ?>">
                                <div class="_map<?php echo $map_class; ?>" data-src="<?php echo $item['map_url']; ?>">
					                <?php if ( isset( $item['map_image'] ) && $item['map_image'] ) { ?>
                                        <div class="_map__bg"><?php echo wp_get_attachment_image( $item['map_image'], 'medium_large' ); ?></div>
					                <?php } ?>
                                </div>
				                <?php if ( $item['map_contact'] ) { ?>
                                    <div class="wescle-map-contacts">
						                <?php if ( $item['map_contact_title'] ) { ?>
                                            <div class="title title_divider"><?php echo $item['map_contact_title']; ?></div>
						                <?php } ?>
                                        <div class="wescle-map-contacts__body">
							                <?php if ( $item['map_contact_text'] ) { ?>
                                                <div class="wescle-map-contacts__text">
                                                    <p><?php echo nl2br( $item['map_contact_text'] ); ?></p>
                                                </div>
							                <?php } ?>
							                <?php if ( $item['map_contact_phone'] ) { ?>
                                                <a class="wescle-map-contacts__link" href="tel:<?php echo Helper::phone_number_format( $item['map_contact_phone'] ); ?>"><?php echo $item['map_contact_phone']; ?></a>
							                <?php } ?>
							                <?php if ( $item['map_contact_email'] ) { ?>
                                                <a class="wescle-map-contacts__link" href="mailto:<?php echo $item['map_contact_email']; ?>"><?php echo $item['map_contact_email']; ?></a>
							                <?php } ?>
                                        </div>
						                <?php if ( $item['map_contact_button1_url'] ) { ?>
                                            <div class="wescle-map-contacts__actions">
								                <?php $target = Helper::is_external_url( $item['map_contact_button1_url'] ) ? ' target="_blank" rel="noopener noreferrer"' : ''; ?>
                                                <a class="btn btn-main btn-main_blue" href="<?php echo $item['map_contact_button1_url']; ?>"<?php echo $target; ?>><?php echo $item['map_contact_button1_text']; ?></a>
								                <?php if ( $item['map_contact_button2_url'] ) { ?>
									                <?php $target = Helper::is_external_url( $item['map_contact_button2_url'] ) ? ' target="_blank" rel="noopener noreferrer"' : ''; ?>
                                                    <a class="btn btn-main btn-main_blue" href="<?php echo $item['map_contact_button2_url']; ?>"<?php echo $target; ?>><?php echo $item['map_contact_button2_text']; ?></a>
								                <?php } ?>
                                            </div>
						                <?php } ?>
                                    </div>
				                <?php } ?>
                            </div>
		                <?php } ?>
                    </div>
                </div>
			<?php } ?>
        </div>
    </div>
</div>