<?php
$block_enabled = get_theme_mod( 'home_licenses_enabled', false );
if ( ! $block_enabled ) {
	return;
}

if ( is_front_page() ) {
	if ( ! get_theme_mod( 'home_licenses_enabled_home', true ) ) {
		return;
	}
}

$title      = get_theme_mod( 'home_licenses_title' );
$title_type = get_theme_mod( 'home_licenses_title_type', 'div' );
$text       = get_theme_mod( 'home_licenses_text' );

$home_licenses_action_label = get_theme_mod( 'home_licenses_action_label' );
$home_licenses_action_date  = get_theme_mod( 'home_licenses_action_date' );
$home_licenses_action_hours = get_theme_mod( 'home_licenses_action_hours' );

if ( get_theme_mod( 'home_licenses_action_type', 'date' ) == 'date' ) {
	$timer_data_attr = 'data-timer-stop="' . $home_licenses_action_date . 'T23:59:59"';
}
else {
	$timer_data_attr = 'data-timer-by="' . $home_licenses_action_hours . '"';
}

$license_timer = false;
if ( $home_licenses_action_date || $home_licenses_action_hours ) {
	$license_timer = true;
}

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_licenses_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_licenses_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_licenses_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="licenses<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_licenses_image_bg' ); ?>
    <svg class="visually-hidden" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="22" height="22" viewbox="0 0 22 22">
        <defs>
            <radialgradient id="radial-orange" cx="0.564" cy="0.266" r="0.691" gradienttransform="matrix(0.986, 0.019, -0.019, 1, 0.014, -0.011)" gradientunits="objectBoundingBox">
                <stop offset="0" stop-color="#ffbf00"></stop>
                <stop offset="0.976" stop-color="#ff9300"></stop>
            </radialgradient>
        </defs>
    </svg>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="licenses__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
		<?php if ( $text ) { ?>
            <div class="_section-about">
                <div class="_section-about__text"><?php echo $text; ?></div>
            </div>
		<?php } ?>

		<?php
		$args = [
			'license_timer'              => $license_timer,
			'timer_data_attr'            => $timer_data_attr,
			'home_licenses_action_label' => $home_licenses_action_label,
		];
		get_template_part( 'template-parts/content/license', 'tabs', $args );
		?>
    </div>
</div>