<?php
$block_enabled = get_theme_mod( 'home_infotabs_enabled' );
if ( ! $block_enabled ) {
	return;
}

$title      = get_theme_mod( 'home_infotabs_title', '' );
$title_type = get_theme_mod( 'home_infotabs_title_type', 'div' );
$text       = get_theme_mod( 'home_infotabs_text' );

$info_tabs_data = Helper::get_info_tabs_data();
$tab_posts      = $info_tabs_data['tabs'];
if ( ! $tab_posts ) {
	return;
}

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_infotabs_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_infotabs_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_infotabs_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="info-tabs<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_infotabs_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="info-tabs__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
		<?php if ( $text ) { ?>
            <div class="info-tabs__about _section-about">
                <div class="_section-about__text"><?php echo $text; ?></div>
            </div>
		<?php } ?>
		<?php get_template_part( 'template-parts/home/infotabs-tabs', null, [ 'tab_posts' => $tab_posts ] ); ?>
    </div>
</div>